/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CodeInstallInfo;
import com.oracle.svm.graal.isolated.ForeignIsolateReferenceAdjusterData;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.svm.graal.isolated.IsolatedReferenceAdjuster;
import com.oracle.svm.graal.isolated.IsolatedRuntimeMethodInfoAccess;
import com.oracle.svm.graal.meta.RuntimeCodeInstaller;
import com.oracle.svm.graal.meta.SubstrateInstalledCodeImpl;
import com.oracle.svm.graal.meta.SubstrateMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class IsolatedRuntimeCodeInstaller
extends RuntimeCodeInstaller {
    private final IsolateThread targetIsolate;
    private final CompilationIdentifier compilationId;

    public static ClientHandle<SubstrateInstalledCode> installInClientIsolate(ImageHeapRef<SubstrateMethod> methodRef, CompilationResult compilationResult, ClientHandle<? extends SubstrateInstalledCode.Factory> installedCodeFactoryHandle) {
        SubstrateMethod method = ImageHeapObjects.deref(methodRef);
        ClientIsolateThread clientIsolate = IsolatedCompileContext.get().getClient();
        CodeInstallInfo installInfo = new IsolatedRuntimeCodeInstaller(clientIsolate, method, compilationResult).doPrepareInstall();
        return IsolatedRuntimeCodeInstaller.installInClientIsolate0(clientIsolate, methodRef, installInfo, installedCodeFactoryHandle);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ClientHandle<SubstrateInstalledCode> installInClientIsolate0(@CEntryPoint.IsolateThreadContext ClientIsolateThread isolate, ImageHeapRef<SubstrateMethod> methodRef, CodeInstallInfo installInfo, ClientHandle<? extends SubstrateInstalledCode.Factory> installedCodeFactoryHandle) {
        SubstrateMethod method = ImageHeapObjects.deref(methodRef);
        return IsolatedRuntimeCodeInstaller.installMethodCodeInClientIsolate(installInfo, installedCodeFactoryHandle, method);
    }

    private static ClientHandle<SubstrateInstalledCode> installMethodCodeInClientIsolate(CodeInstallInfo installInfo, ClientHandle<? extends SubstrateInstalledCode.Factory> installedCodeFactoryHandle, SharedRuntimeMethod method) {
        SubstrateInstalledCode.Factory installedCodeFactory = IsolatedCompileClient.get().unhand(installedCodeFactoryHandle);
        SubstrateInstalledCode installedCode = installedCodeFactory != null ? installedCodeFactory.createSubstrateInstalledCode() : new SubstrateInstalledCodeImpl(method);
        installedCode.setCompilationId(IsolatedCompileClient.get().unhand(installInfo.getCompilationId()));
        IsolatedRuntimeCodeInstaller.installPrepared(method, installInfo, installedCode);
        return IsolatedCompileClient.get().hand(installedCode);
    }

    public static ClientHandle<SubstrateInstalledCode> installInClientIsolate(SharedRuntimeMethod compilerMethod, ClientHandle<? extends SharedRuntimeMethod> clientMethodHandle, CompilationResult compilationResult, ClientHandle<? extends SubstrateInstalledCode.Factory> installedCodeFactoryHandle) {
        ClientIsolateThread clientIsolate = IsolatedCompileContext.get().getClient();
        CodeInstallInfo installInfo = new IsolatedRuntimeCodeInstaller(clientIsolate, compilerMethod, compilationResult).doPrepareInstall();
        return IsolatedRuntimeCodeInstaller.installInClientIsolate1(clientIsolate, clientMethodHandle, installInfo, installedCodeFactoryHandle);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ClientHandle<SubstrateInstalledCode> installInClientIsolate1(@CEntryPoint.IsolateThreadContext ClientIsolateThread isolate, ClientHandle<? extends SharedRuntimeMethod> methodHandle, CodeInstallInfo installInfo, ClientHandle<? extends SubstrateInstalledCode.Factory> installedCodeFactoryHandle) {
        SharedRuntimeMethod method = IsolatedCompileClient.get().unhand(methodHandle);
        return IsolatedRuntimeCodeInstaller.installMethodCodeInClientIsolate(installInfo, installedCodeFactoryHandle, method);
    }

    private CodeInstallInfo doPrepareInstall() {
        IsolatedReferenceAdjuster adjuster = new IsolatedReferenceAdjuster();
        CodeInfo codeInfo = RuntimeCodeInfoAccess.allocateMethodInfo();
        this.doPrepareInstall(adjuster, codeInfo);
        RuntimeCodeInfoAccess.guaranteeAllObjectsInImageHeap(codeInfo);
        ClientHandle<CompilationIdentifier> id = (ClientHandle<CompilationIdentifier>)IsolatedHandles.nullHandle();
        if (this.compilationId instanceof IsolatedObjectProxy) {
            IsolatedObjectProxy proxy = (IsolatedObjectProxy)this.compilationId;
            id = proxy.getHandle();
        }
        CodeInstallInfo installInfo = (CodeInstallInfo)UnmanagedMemory.malloc((int)SizeOf.get(CodeInstallInfo.class));
        installInfo.setCodeInfo(codeInfo);
        installInfo.setAdjusterData(adjuster.exportData());
        installInfo.setCompilationId(id);
        IsolatedRuntimeMethodInfoAccess.untrackInCurrentIsolate(installInfo.getCodeInfo());
        return installInfo;
    }

    private static void installPrepared(SharedMethod method, CodeInstallInfo installInfo, SubstrateInstalledCode installedCode) {
        IsolatedRuntimeMethodInfoAccess.startTrackingInCurrentIsolate(installInfo.getCodeInfo());
        RuntimeCodeInfoAccess.acquireThreadWriteAccess();
        try {
            IsolatedReferenceAdjuster.adjustAndDispose(installInfo.getAdjusterData(), IsolatedCompileClient.get().getHandleSet());
            installInfo.setAdjusterData((ForeignIsolateReferenceAdjusterData)WordFactory.nullPointer());
        }
        finally {
            RuntimeCodeInfoAccess.releaseThreadWriteAccess();
        }
        IsolatedRuntimeCodeInstaller.doInstallPrepared(method, installInfo.getCodeInfo(), installedCode);
        UnmanagedMemory.free((PointerBase)installInfo);
    }

    private IsolatedRuntimeCodeInstaller(IsolateThread targetIsolate, SharedRuntimeMethod method, CompilationResult compilation) {
        super(method, compilation);
        this.targetIsolate = targetIsolate;
        this.compilationId = compilation.getCompilationId();
    }

    @Override
    protected Pointer allocateCodeMemory(long size) {
        CodePointer memory = IsolatedRuntimeCodeInstaller.allocateCodeMemory0(this.targetIsolate, WordFactory.unsigned((long)size));
        if (memory.isNull()) {
            throw new OutOfMemoryError();
        }
        return (Pointer)memory;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static CodePointer allocateCodeMemory0(IsolateThread targetIsolate, UnsignedWord size) {
        return RuntimeCodeInfoAccess.allocateCodeMemory(size);
    }

    @Override
    protected void makeCodeMemoryReadOnly(Pointer start, long size) {
        IsolatedRuntimeCodeInstaller.makeCodeMemoryReadOnly0(this.targetIsolate, start, size);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void makeCodeMemoryReadOnly0(IsolateThread targetIsolate, Pointer start, long size) {
        RuntimeCodeInfoAccess.makeCodeMemoryExecutableReadOnly((CodePointer)start, WordFactory.unsigned((long)size));
    }

    @Override
    protected void makeCodeMemoryWriteableNonExecutable(Pointer start, long size) {
        IsolatedRuntimeCodeInstaller.makeCodeMemoryWriteableNonExecutable0(this.targetIsolate, start, size);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void makeCodeMemoryWriteableNonExecutable0(IsolateThread targetIsolate, Pointer start, long size) {
        RuntimeCodeInfoAccess.makeCodeMemoryWriteableNonExecutable((CodePointer)start, WordFactory.unsigned((long)size));
    }
}

