/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.SynchAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.WINDOWS.class})
class WindowsParkEvent
extends ParkEvent {
    private final WinBase.HANDLE eventHandle = SynchAPI.CreateEventA(WordFactory.nullPointer(), 0, 0, WordFactory.nullPointer());

    WindowsParkEvent() {
        VMError.guarantee(this.eventHandle.rawValue() != 0L, "CreateEventA failed");
    }

    @Override
    protected void reset() {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            int status = SynchAPI.ResetEvent(this.eventHandle);
            VMError.guarantee(status != 0, "ResetEvent failed");
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @Override
    protected void condWait() {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            int status = SynchAPI.WaitForSingleObject(this.eventHandle, SynchAPI.INFINITE());
            if (status != SynchAPI.WAIT_OBJECT_0()) {
                Log.log().newline().string("WindowsParkEvent.condWait failed, status returned:  ").hex(status);
                Log.log().newline().string("GetLastError returned:  ").hex(WinBase.GetLastError()).newline();
                throw VMError.shouldNotReachHere("WaitForSingleObject failed");
            }
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void condTimedWait(long delayNanos) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            int timeout;
            int maxTimeout = 0x10000000;
            long delayMillis = Math.max(0L, TimeUtils.roundUpNanosToMillis(delayNanos));
            do {
                int status;
                if ((status = SynchAPI.WaitForSingleObject(this.eventHandle, timeout = delayMillis < 0x10000000L ? (int)delayMillis : 0x10000000)) == SynchAPI.WAIT_OBJECT_0()) {
                    break;
                }
                if (status == SynchAPI.WAIT_TIMEOUT()) continue;
                Log.log().newline().string("WindowsParkEvent.condTimedWait failed, status returned:  ").hex(status);
                Log.log().newline().string("GetLastError returned:  ").hex(WinBase.GetLastError()).newline();
                throw VMError.shouldNotReachHere("WaitForSingleObject failed");
            } while ((delayMillis -= (long)timeout) > 0L);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @Override
    protected void unpark() {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            int status = SynchAPI.SetEvent(this.eventHandle);
            VMError.guarantee(status != 0, "SetEvent failed");
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }
}

