/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.windows.WindowsUtils;
import com.oracle.svm.core.windows.headers.FileAPI;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.UnsignedWord;

public class WindowsLogHandler
implements LogHandler {
    public void log(CCharPointer bytes, UnsignedWord length) {
        if (!WindowsUtils.writeBytes(WindowsLogHandler.getOutputFile(), bytes, length)) {
            this.fatalError();
        }
    }

    public void flush() {
        WindowsUtils.flush(WindowsLogHandler.getOutputFile());
    }

    public void fatalError() {
        if (SubstrateDiagnostics.isFatalErrorHandlingInProgress()) {
            VMThreads.singleton().nativeSleep(3000);
        }
        LibC.abort();
    }

    private static int getOutputFile() {
        return FileAPI.GetStdHandle(FileAPI.STD_ERROR_HANDLE());
    }
}

