/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.thread.ThreadListener;
import java.util.Arrays;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class ThreadListenerSupport {
    private ThreadListener[] listeners = new ThreadListener[0];

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ThreadListenerSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized void register(ThreadListener listener) {
        assert (listener != null);
        int oldLength = this.listeners.length;
        this.listeners = Arrays.copyOf(this.listeners, oldLength + 1);
        this.listeners[oldLength] = listener;
    }

    @Fold
    public static ThreadListenerSupport get() {
        return (ThreadListenerSupport)ImageSingletons.lookup(ThreadListenerSupport.class);
    }

    @Uninterruptible(reason="Force that all listeners are uninterruptible.")
    public void beforeThreadStart(IsolateThread isolateThread, Thread javaThread) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].beforeThreadRun(isolateThread, javaThread);
        }
    }

    @Uninterruptible(reason="Force that all listeners are uninterruptible.")
    public void afterThreadExit(IsolateThread isolateThread, Thread javaThread) {
        for (int i = this.listeners.length - 1; i >= 0; --i) {
            this.listeners[i].afterThreadExit(isolateThread, javaThread);
        }
    }
}

