/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.SpinLockUtils;
import com.oracle.svm.core.thread.UnacquiredThreadData;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import jdk.internal.misc.Unsafe;

public final class ThreadData
extends UnacquiredThreadData {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final long LOCK_OFFSET;
    private static final long UNSAFE_PARK_EVENT_OFFSET;
    private static final long SLEEP_PARK_EVENT_OFFSET;
    private volatile int lock;
    private boolean detached;
    private long refCount;
    private volatile ParkEvent unsafeParkEvent;
    private volatile ParkEvent sleepParkEvent;

    public ParkEvent getSleepParkEvent() {
        assert (this.isForCurrentThread() || this.refCount > 0L);
        return this.sleepParkEvent;
    }

    public ParkEvent ensureUnsafeParkEvent() {
        assert (this.isForCurrentThread() || this.refCount > 0L);
        ParkEvent existingEvent = this.unsafeParkEvent;
        if (existingEvent != null) {
            return existingEvent;
        }
        this.initializeParkEvent(UNSAFE_PARK_EVENT_OFFSET, false);
        return this.unsafeParkEvent;
    }

    public ParkEvent ensureSleepParkEvent() {
        assert (this.isForCurrentThread() || this.refCount > 0L);
        ParkEvent existingEvent = this.sleepParkEvent;
        if (existingEvent != null) {
            return existingEvent;
        }
        this.initializeParkEvent(SLEEP_PARK_EVENT_OFFSET, true);
        return this.sleepParkEvent;
    }

    @Override
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public ThreadData acquire() {
        SpinLockUtils.lockNoTransition(this, LOCK_OFFSET);
        try {
            if (this.detached) {
                ThreadData threadData = null;
                return threadData;
            }
            assert (this.refCount >= 0L);
            ++this.refCount;
            ThreadData threadData = this;
            return threadData;
        }
        finally {
            SpinLockUtils.unlock(this, LOCK_OFFSET);
        }
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public void release() {
        SpinLockUtils.lockNoTransition(this, LOCK_OFFSET);
        try {
            assert (this.refCount > 0L);
            --this.refCount;
            if (this.detached && this.refCount == 0L) {
                this.free();
            }
        }
        finally {
            SpinLockUtils.unlock(this, LOCK_OFFSET);
        }
    }

    @Override
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public void detach() {
        assert (this.isForCurrentThread() || VMOperation.isInProgressAtSafepoint()) : "may only be called by the detaching thread or at a safepoint";
        assert (!this.detached) : "may only be called once";
        SpinLockUtils.lockNoTransition(this, LOCK_OFFSET);
        try {
            this.detached = true;
            if (this.refCount == 0L) {
                this.free();
            }
        }
        finally {
            SpinLockUtils.unlock(this, LOCK_OFFSET);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void free() {
        assert (this.isLocked());
        if (this.unsafeParkEvent != null) {
            ParkEvent.release(this.unsafeParkEvent);
            this.unsafeParkEvent = null;
        }
        if (this.sleepParkEvent != null) {
            ParkEvent.release(this.sleepParkEvent);
            this.sleepParkEvent = null;
        }
    }

    private void initializeParkEvent(long offset, boolean isSleepEvent) {
        ParkEvent newEvent = ParkEvent.acquire(isSleepEvent);
        if (!this.tryToStoreParkEvent(offset, newEvent)) {
            ParkEvent.release(newEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private boolean tryToStoreParkEvent(long offset, ParkEvent newEvent) {
        SpinLockUtils.lockNoTransition(this, LOCK_OFFSET);
        try {
            if (UNSAFE.getObject(this, offset) != null) {
                boolean bl = false;
                return bl;
            }
            UNSAFE.putObjectVolatile(this, offset, newEvent);
            boolean bl = true;
            return bl;
        }
        finally {
            SpinLockUtils.unlock(this, LOCK_OFFSET);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean isForCurrentThread() {
        return this == PlatformThreads.getCurrentThreadData();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean isLocked() {
        return this.lock == 1;
    }

    static {
        try {
            LOCK_OFFSET = UNSAFE.objectFieldOffset(ThreadData.class.getDeclaredField("lock"));
            UNSAFE_PARK_EVENT_OFFSET = UNSAFE.objectFieldOffset(ThreadData.class.getDeclaredField("unsafeParkEvent"));
            SLEEP_PARK_EVENT_OFFSET = UNSAFE.objectFieldOffset(ThreadData.class.getDeclaredField("sleepParkEvent"));
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

