/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.LoomJDK;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.thread.LoomSupport;
import com.oracle.svm.core.thread.Target_java_lang_ContinuationScope;
import com.oracle.svm.core.thread.Target_java_lang_Thread;

@TargetClass(className="java.lang.Continuation", onlyWith={LoomJDK.class})
public final class Target_java_lang_Continuation {
    @Alias
    Runnable target;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public Continuation internal;
    @Alias
    short cs;
    @Alias
    Object yieldInfo;
    @Alias
    byte flags;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias, isFinal=true)
    static byte FLAG_SAFEPOINT_YIELD = (byte)2;
    @Alias
    boolean done;

    @Alias
    public Target_java_lang_Continuation(Target_java_lang_ContinuationScope scope, Runnable target) {
    }

    @Alias
    public static native boolean yield(Target_java_lang_ContinuationScope var0);

    @Substitute
    private boolean isEmpty() {
        return this.internal.isEmpty();
    }

    @Alias
    public native Target_java_lang_ContinuationScope getScope();

    @Alias
    public native Target_java_lang_Continuation getParent();

    @Alias
    public native void run();

    @Alias
    native boolean yield0(Target_java_lang_ContinuationScope var1, Target_java_lang_Continuation var2);

    @Alias
    private native void setMounted(boolean var1);

    @Alias
    private native void postYieldCleanup(int var1);

    @Substitute
    private void mount() {
        this.setMounted(true);
    }

    @Substitute
    private void unmount() {
        this.setMounted(false);
    }

    @Alias
    public native boolean isPreempted();

    @Substitute
    @NeverInline(value="access stack pointer")
    private static int isPinned0(Target_java_lang_ContinuationScope scope) {
        return LoomSupport.isPinned(SubstrateUtil.cast(Thread.currentThread(), Target_java_lang_Thread.class), scope, true);
    }

    @Substitute
    boolean isStarted() {
        return this.internal.isStarted();
    }

    @Alias
    native boolean isDone();

    @Alias
    @TargetElement(onlyWith={LoomJDK.class})
    public static native Target_java_lang_Continuation getCurrentContinuation(Target_java_lang_ContinuationScope var0);

    @Substitute
    static void enterSpecial(Target_java_lang_Continuation cont, boolean isContinue) {
        Target_java_lang_Continuation.enter(cont, isContinue);
    }

    @Substitute
    private static int doYield(int scopes) {
        Target_java_lang_Continuation cont;
        assert (scopes == 0);
        Target_java_lang_Thread tjlt = SubstrateUtil.cast(Thread.currentThread(), Target_java_lang_Thread.class);
        int pinnedReason = LoomSupport.isPinned(tjlt, (cont = LoomSupport.getContinuation(tjlt)).getScope(), true);
        if (pinnedReason != 0) {
            return pinnedReason;
        }
        return LoomSupport.yield(cont);
    }

    @Substitute
    private void finish() {
        this.done = true;
        assert (this.isEmpty());
    }

    @Substitute
    private static void enter(Target_java_lang_Continuation cont, boolean isContinue) {
        if (!isContinue) {
            assert (cont.internal == null);
            cont.internal = new Continuation(cont::enter0);
        }
        cont.internal.enter();
    }

    @Substitute
    private void enter0() {
        try {
            this.target.run();
        }
        finally {
            this.finish();
        }
    }

    @Substitute
    private int tryForceYield0(Target_java_lang_Thread thread) {
        int preemptResult;
        Target_java_lang_Continuation cont;
        Target_java_lang_Continuation innermost = cont = thread.getContinuation();
        while (cont != null && cont != this) {
            cont = cont.getParent();
        }
        if (cont == null) {
            return -1;
        }
        if (innermost != cont) {
            Target_java_lang_ContinuationScope scope = cont.getScope();
            int pinned = LoomSupport.isPinned(thread, cont.getScope(), false);
            if (pinned != 0) {
                return pinned;
            }
            cont.yieldInfo = scope;
        }
        if ((preemptResult = this.internal.tryPreempt(SubstrateUtil.cast(thread, Thread.class))) == 0) {
            this.flags = FLAG_SAFEPOINT_YIELD;
        }
        return LoomSupport.convertInternalYieldResult(preemptResult);
    }
}

