/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.StubCallingConvention;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class Continuation {
    public static final int YIELDING = -2;
    public static final int YIELD_SUCCESS = 0;
    private final Runnable target;
    public StoredContinuation stored;
    private Pointer sp;
    private CodePointer ip;
    private Pointer baseSP;
    private boolean done;
    private int overflowCheckState;

    @Fold
    public static boolean isSupported() {
        return SubstrateOptions.SupportContinuations.getValue();
    }

    Continuation(Runnable target) {
        this.target = target;
    }

    public Pointer getBaseSP() {
        return this.baseSP;
    }

    void enter() {
        boolean isContinue;
        int stateBefore = StackOverflowCheck.singleton().getState();
        VMError.guarantee(!StackOverflowCheck.singleton().isYellowZoneAvailable());
        boolean bl = isContinue = this.stored != null;
        if (isContinue) {
            StackOverflowCheck.singleton().setState(this.overflowCheckState);
        }
        try {
            Continuation.enter0(this, isContinue);
        }
        catch (StackOverflowError e) {
            throw e == ImplicitExceptions.CACHED_STACK_OVERFLOW_ERROR ? new StackOverflowError() : e;
        }
        finally {
            this.overflowCheckState = StackOverflowCheck.singleton().getState();
            StackOverflowCheck.singleton().setState(stateBefore);
            assert (this.sp.isNull() && this.ip.isNull() && this.baseSP.isNull());
        }
    }

    @StubCallingConvention
    @NeverInline(value="Keep the frame with the saved registers.")
    private static void enter0(Continuation self, boolean isContinue) {
        self.enter1(isContinue);
    }

    @NeverInline(value="Accesses caller stack pointer and return address.")
    @Uninterruptible(reason="Prevent safepoint checks between copying frames and farReturn.")
    private Object enter1(boolean isContinue) {
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        CodePointer callerIP = KnownIntrinsics.readReturnAddress();
        Pointer currentSP = KnownIntrinsics.readStackPointer();
        assert (this.sp.isNull() && this.ip.isNull() && this.baseSP.isNull());
        if (isContinue) {
            assert (this.stored != null);
            int totalSize = StoredContinuationAccess.getFramesSizeInBytes(this.stored);
            Pointer topSP = currentSP.subtract(totalSize);
            if (!StackOverflowCheck.singleton().isWithinBounds((UnsignedWord)topSP)) {
                throw ImplicitExceptions.CACHED_STACK_OVERFLOW_ERROR;
            }
            CodePointer enterIP = ((ContinuationSupport)ImageSingletons.lookup(ContinuationSupport.class)).copyFrames(this.stored, topSP);
            this.ip = callerIP;
            this.sp = callerSP;
            this.baseSP = currentSP;
            this.stored = null;
            KnownIntrinsics.farReturn(0, topSP, enterIP, false);
            throw VMError.shouldNotReachHere();
        }
        assert (this.stored == null);
        this.ip = callerIP;
        this.sp = callerSP;
        this.baseSP = currentSP;
        this.enter2();
        throw VMError.shouldNotReachHere();
    }

    @NeverInline(value="Needs a separate frame which is part of the continuation stack that we can eventually return to.")
    @Uninterruptible(reason="Not actually, but because caller is uninterruptible.", calleeMustBe=false)
    private void enter2() {
        try {
            this.target.run();
        }
        catch (Throwable t) {
            throw VMError.shouldNotReachHere(t);
        }
        Pointer returnSP = this.sp;
        CodePointer returnIP = this.ip;
        this.done = true;
        this.ip = (CodePointer)WordFactory.nullPointer();
        this.sp = (Pointer)WordFactory.nullPointer();
        this.baseSP = (Pointer)WordFactory.nullPointer();
        assert (this.isEmpty());
        KnownIntrinsics.farReturn(null, returnSP, returnIP, false);
        throw VMError.shouldNotReachHere();
    }

    int tryPreempt(Thread thread) {
        TryPreemptOperation vmOp = new TryPreemptOperation(this, thread);
        vmOp.enqueue();
        return vmOp.preemptStatus;
    }

    int yield() {
        return Continuation.yield0(this);
    }

    @StubCallingConvention
    @NeverInline(value="Keep the frame with the saved registers.")
    private static Integer yield0(Continuation self) {
        return self.yield1();
    }

    @NeverInline(value="access stack pointer")
    private Integer yield1() {
        Pointer leafSP = KnownIntrinsics.readCallerStackPointer();
        CodePointer leafIP = KnownIntrinsics.readReturnAddress();
        Pointer returnSP = this.sp;
        CodePointer returnIP = this.ip;
        int preemptStatus = StoredContinuationAccess.allocateToYield(this, this.baseSP, leafSP, leafIP);
        if (preemptStatus != 0) {
            return preemptStatus;
        }
        this.ip = (CodePointer)WordFactory.nullPointer();
        this.sp = (Pointer)WordFactory.nullPointer();
        this.baseSP = (Pointer)WordFactory.nullPointer();
        KnownIntrinsics.farReturn(null, returnSP, returnIP, false);
        throw VMError.shouldNotReachHere();
    }

    public boolean isStarted() {
        return this.stored != null || this.ip.isNonNull();
    }

    public boolean isEmpty() {
        return this.stored == null && this.ip.isNull();
    }

    public boolean isDone() {
        return this.done;
    }

    private static final class TryPreemptOperation
    extends JavaVMOperation {
        int preemptStatus = 0;
        final Continuation cont;
        final Thread thread;

        TryPreemptOperation(Continuation cont, Thread thread) {
            super(VMOperationInfos.get(TryPreemptOperation.class, "Try to preempt continuation", VMOperation.SystemEffect.SAFEPOINT));
            this.cont = cont;
            this.thread = thread;
        }

        @Override
        public void operate() {
            IsolateThread vmThread = PlatformThreads.getIsolateThread(this.thread);
            Pointer baseSP = this.cont.baseSP;
            Pointer returnSP = this.cont.sp;
            CodePointer returnIP = this.cont.ip;
            this.preemptStatus = StoredContinuationAccess.allocateToPreempt(this.cont, baseSP, vmThread);
            if (this.preemptStatus == 0) {
                this.cont.sp = (Pointer)WordFactory.nullPointer();
                this.cont.baseSP = (Pointer)WordFactory.nullPointer();
                this.cont.ip = (CodePointer)WordFactory.nullPointer();
                VMThreads.ActionOnExitSafepointSupport.setSwitchStack(vmThread);
                VMThreads.ActionOnExitSafepointSupport.setSwitchStackTarget(vmThread, returnSP, returnIP);
            }
        }
    }
}

