/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.sampler.SamplerSampleWriter;
import com.oracle.svm.core.sampler.SamplerThreadLocal;
import com.oracle.svm.core.stack.ParameterizedStackFrameVisitor;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

final class SamplerStackWalkVisitor
extends ParameterizedStackFrameVisitor<Void> {
    SamplerStackWalkVisitor() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame, Void voidData) {
        return SamplerSampleWriter.putLong(SamplerThreadLocal.getWriterData(), ip.rawValue());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected boolean unknownFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame, Void data) {
        SamplerThreadLocal.increaseUnparseableStacks();
        return false;
    }
}

