/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.sampler.SamplerThreadLocal;
import com.oracle.svm.core.sampler.SubstrateSigprofHandler;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

class SamplerIsolateLocal
implements IsolateListenerSupport.IsolateListener {
    private static final CGlobalData<Pointer> firstIsolate = CGlobalDataFactory.createWord();
    private static UnsignedWord key = (UnsignedWord)WordFactory.zero();

    SamplerIsolateLocal() {
    }

    @Override
    @Uninterruptible(reason="Thread state not yet set up.")
    public void afterCreateIsolate(Isolate isolate) {
        if (firstIsolate.get().logicCompareAndSwapWord(0, (WordBase)WordFactory.nullPointer(), (WordBase)Isolates.getHeapBase(isolate), NamedLocationIdentity.OFF_HEAP_LOCATION)) {
            key = SubstrateSigprofHandler.singleton().createThreadLocalKey();
        }
    }

    @Override
    @Uninterruptible(reason="The isolate teardown is in progress.")
    public void onIsolateTeardown() {
        if (SamplerIsolateLocal.isKeySet()) {
            UnsignedWord oldKey = key;
            key = (UnsignedWord)WordFactory.zero();
            if (SubstrateSigprofHandler.singleton().isProfilingEnabled()) {
                SamplerThreadLocal.teardown(CurrentIsolate.getCurrentThread());
            }
            SubstrateSigprofHandler.singleton().deleteThreadLocalKey(oldKey);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Isolate getIsolate() {
        return (Isolate)firstIsolate.get().readWord(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getKey() {
        return key;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isKeySet() {
        return key.aboveThan(0);
    }
}

