/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.annotate.InvokeJavaFunctionPointer;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.InvocationTargetException;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

@InternalVMMethod
public final class ReflectionAccessorHolder {
    private static Object invokePrototype(Object obj, Object[] args, CFunctionPointer invokedMethod) {
        throw VMError.shouldNotReachHere("Only used as a prototype for generated methods");
    }

    private static void methodHandleInvokeError(Object obj, Object[] args, CFunctionPointer invokedMethod) throws InvocationTargetException {
        throw new InvocationTargetException(new UnsupportedOperationException("MethodHandle.invoke() and MethodHandle.invokeExact() cannot be invoked through reflection"));
    }

    private static Object newInstanceError(Object obj, Object[] args, CFunctionPointer invokedMethod) throws InstantiationException {
        throw new InstantiationException("Only non-abstract instance classes can be instantiated using reflection");
    }

    @NeverInline(value="Exception slow path")
    private static void throwIllegalArgumentExceptionWithReceiver(Object obj, Object[] args) {
        throw ReflectionAccessorHolder.throwIllegalArgumentException(true, obj, args);
    }

    @NeverInline(value="Exception slow path")
    private static void throwIllegalArgumentExceptionWithoutReceiver(Object[] args) {
        throw ReflectionAccessorHolder.throwIllegalArgumentException(false, null, args);
    }

    private static RuntimeException throwIllegalArgumentException(boolean withReceiver, Object obj, Object[] args) {
        String sep = System.lineSeparator();
        StringBuilder msg = new StringBuilder();
        msg.append("Illegal arguments for reflective invocation");
        if (withReceiver) {
            msg.append(sep).append("  obj: ").append(obj == null ? "null" : obj.getClass().getTypeName());
        }
        if (args == null) {
            msg.append(sep).append("  args: null");
        } else {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                msg.append(sep).append("  args[").append(i).append("]: ").append(arg == null ? "null" : arg.getClass().getTypeName());
            }
        }
        throw new IllegalArgumentException(msg.toString());
    }

    public static interface MethodInvokeFunctionPointer
    extends CFunctionPointer {
        @InvokeJavaFunctionPointer
        public Object invoke(Object var1, Object[] var2, CFunctionPointer var3);
    }
}

