/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.reflect.SubstrateMethodAccessor;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

final class ComputeVTableOffset
implements RecomputeFieldValue.CustomFieldValueComputer {
    ComputeVTableOffset() {
    }

    @Override
    public RecomputeFieldValue.ValueAvailability valueAvailability() {
        return RecomputeFieldValue.ValueAvailability.AfterAnalysis;
    }

    @Override
    public Class<?>[] types() {
        return new Class[]{Integer.TYPE};
    }

    @Override
    public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
        SubstrateMethodAccessor accessor = (SubstrateMethodAccessor)receiver;
        if (accessor.vtableOffset == -559087615) {
            SharedMethod member = (SharedMethod)metaAccess.lookupJavaMethod(accessor.member);
            return KnownOffsets.singleton().getVTableOffset(member.getVTableIndex());
        }
        VMError.guarantee(accessor.vtableOffset == -1);
        return accessor.vtableOffset;
    }
}

