/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.aarch64;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.UContextRegisterDumper;
import com.oracle.svm.core.posix.headers.Signal;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class AArch64DarwinUContextRegisterDumper
implements UContextRegisterDumper {
    @Override
    public void dumpRegisters(Log log, Signal.ucontext_t uContext, boolean printLocationInfo, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        Signal.AArch64DarwinMContext64 sigcontext = uContext.uc_mcontext_darwin_aarch64();
        Signal.GregsPointer regs = sigcontext.regs();
        RegisterDumper.dumpReg(log, "R0  ", regs.read(0), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R1  ", regs.read(1), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R2  ", regs.read(2), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R3  ", regs.read(3), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R4  ", regs.read(4), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R5  ", regs.read(5), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R6  ", regs.read(6), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R7  ", regs.read(7), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R8  ", regs.read(8), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R9  ", regs.read(9), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R10 ", regs.read(10), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R11 ", regs.read(11), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R12 ", regs.read(12), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R13 ", regs.read(13), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R14 ", regs.read(14), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R15 ", regs.read(15), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R16 ", regs.read(16), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R17 ", regs.read(17), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R18 ", regs.read(18), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R19 ", regs.read(19), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R20 ", regs.read(20), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R21 ", regs.read(21), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R22 ", regs.read(22), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R23 ", regs.read(23), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R24 ", regs.read(24), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R25 ", regs.read(25), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R26 ", regs.read(26), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R27 ", regs.read(27), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R28 ", regs.read(28), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R29 ", sigcontext.fp(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R30 ", sigcontext.lr(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "SP  ", sigcontext.sp(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "PC  ", sigcontext.pc(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public PointerBase getHeapBase(Signal.ucontext_t uContext) {
        Signal.AArch64DarwinMContext64 sigcontext = uContext.uc_mcontext_darwin_aarch64();
        return WordFactory.pointer((long)sigcontext.regs().read(27));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public PointerBase getThreadPointer(Signal.ucontext_t uContext) {
        Signal.AArch64DarwinMContext64 sigcontext = uContext.uc_mcontext_darwin_aarch64();
        return WordFactory.pointer((long)sigcontext.regs().read(28));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase getSP(Signal.ucontext_t uContext) {
        Signal.AArch64DarwinMContext64 sigcontext = uContext.uc_mcontext_darwin_aarch64();
        return WordFactory.pointer((long)sigcontext.sp());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase getIP(Signal.ucontext_t uContext) {
        Signal.AArch64DarwinMContext64 sigcontext = uContext.uc_mcontext_darwin_aarch64();
        return WordFactory.pointer((long)sigcontext.pc());
    }
}

