/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.os.ImageHeapProvider;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.UnsignedWord;

public abstract class AbstractImageHeapProvider
implements ImageHeapProvider {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static UnsignedWord getImageHeapAddressSpaceSize() {
        UnsignedWord imageHeapSizeInFile = AbstractImageHeapProvider.getImageHeapSizeInFile();
        return imageHeapSizeInFile.add(Heap.getHeap().getImageHeapOffsetInAddressSpace());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static UnsignedWord getImageHeapSizeInFile() {
        Word imageHeapBegin = Isolates.IMAGE_HEAP_BEGIN.get();
        return Isolates.IMAGE_HEAP_END.get().subtract(imageHeapBegin);
    }
}

