/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.UnsignedUtils;
import java.util.EnumSet;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class AbstractCommittedMemoryProvider
implements CommittedMemoryProvider {
    private final VirtualMemoryTracker tracker = new VirtualMemoryTracker();

    @Override
    @Fold
    public boolean guaranteesHeapPreferredAddressSpaceAlignment() {
        return SubstrateOptions.SpawnIsolates.getValue() != false && ImageHeapProvider.get().guaranteesHeapPreferredAddressSpaceAlignment();
    }

    @Uninterruptible(reason="Still being initialized.")
    protected static int protectSingleIsolateImageHeap() {
        assert (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) : "Must be handled by ImageHeapProvider when SpawnIsolates is enabled";
        assert (Heap.getHeap().getImageHeapNullRegionSize() == 0) : "A null region only makes sense with a heap base.";
        Pointer heapBegin = (Pointer)Isolates.IMAGE_HEAP_BEGIN.get();
        if (Heap.getHeap().getImageHeapOffsetInAddressSpace() != 0) {
            return 8;
        }
        if (!SubstrateOptions.ForceNoROSectionRelocations.getValue().booleanValue()) {
            Word heapSize = Isolates.IMAGE_HEAP_END.get().subtract((UnsignedWord)heapBegin);
            if (VirtualMemoryProvider.get().protect((PointerBase)heapBegin, (UnsignedWord)heapSize, 1) != 0) {
                return 9;
            }
            Pointer writableBegin = (Pointer)Isolates.IMAGE_HEAP_WRITABLE_BEGIN.get();
            Word writableSize = Isolates.IMAGE_HEAP_WRITABLE_END.get().subtract((UnsignedWord)writableBegin);
            if (VirtualMemoryProvider.get().protect((PointerBase)writableBegin, (UnsignedWord)writableSize, 3) != 0) {
                return 9;
            }
        }
        return 0;
    }

    @Override
    public boolean protect(PointerBase start, UnsignedWord nbytes, EnumSet<CommittedMemoryProvider.Access> accessFlags) {
        int success;
        int vmAccessBits = 0;
        if (accessFlags.contains((Object)CommittedMemoryProvider.Access.READ)) {
            vmAccessBits |= 1;
        }
        if (accessFlags.contains((Object)CommittedMemoryProvider.Access.WRITE)) {
            vmAccessBits |= 2;
        }
        if (accessFlags.contains((Object)CommittedMemoryProvider.Access.EXECUTE)) {
            vmAccessBits |= 4;
        }
        return (success = VirtualMemoryProvider.get().protect(start, nbytes, vmAccessBits)) == 0;
    }

    @Override
    public Pointer allocateAlignedChunk(UnsignedWord nbytes, UnsignedWord alignment) {
        return this.allocate(nbytes, alignment, false);
    }

    @Override
    public Pointer allocateUnalignedChunk(UnsignedWord nbytes) {
        return this.allocate(nbytes, WordFactory.unsigned((int)1), false);
    }

    @Override
    public Pointer allocateExecutableMemory(UnsignedWord nbytes, UnsignedWord alignment) {
        return this.allocate(nbytes, alignment, true);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Pointer allocate(UnsignedWord size, UnsignedWord alignment, boolean executable) {
        int access = 3;
        if (executable) {
            access |= 4;
        }
        Pointer reserved = (Pointer)WordFactory.nullPointer();
        if (!UnsignedUtils.isAMultiple(this.getGranularity(), alignment) && (reserved = VirtualMemoryProvider.get().reserve(size, alignment, executable)).isNull()) {
            return (Pointer)WordFactory.nullPointer();
        }
        Pointer committed = VirtualMemoryProvider.get().commit((PointerBase)reserved, size, access);
        if (committed.isNull()) {
            if (reserved.isNonNull()) {
                VirtualMemoryProvider.get().free((PointerBase)reserved, size);
            }
            return (Pointer)WordFactory.nullPointer();
        }
        assert (reserved.isNull() || reserved.equal((UnsignedWord)committed));
        this.tracker.track(size);
        return committed;
    }

    @Override
    public boolean areUnalignedChunksZeroed() {
        return false;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeAlignedChunk(PointerBase start, UnsignedWord nbytes, UnsignedWord alignment) {
        this.free(start, nbytes);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeUnalignedChunk(PointerBase start, UnsignedWord nbytes) {
        this.free(start, nbytes);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeExecutableMemory(PointerBase start, UnsignedWord nbytes, UnsignedWord alignment) {
        this.free(start, nbytes);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void free(PointerBase start, UnsignedWord nbytes) {
        if (VirtualMemoryProvider.get().free(start, nbytes) == 0) {
            this.tracker.untrack(nbytes);
        }
    }

    public static class VirtualMemoryTracker {
        private UnsignedWord totalAllocated = (UnsignedWord)WordFactory.zero();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void track(UnsignedWord size) {
            this.totalAllocated = this.totalAllocated.add(size);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void untrack(UnsignedWord size) {
            this.totalAllocated = this.totalAllocated.subtract(size);
        }
    }
}

