/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.logging;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jfr.logging.JfrLogTag;
import com.oracle.svm.core.jfr.logging.JfrLogging;
import com.oracle.svm.core.jfr.logging.Target_jdk_jfr_internal_LogTag;
import com.oracle.svm.core.util.VMError;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

class JfrLogConfiguration {
    private static final String EMPTY_STRING_DEFAULT_CONFIG = "all=info";
    static final Map<LogTag, Set<JfrLogTag>> LOG_TAG_SETS = JfrLogConfiguration.createLogTagSets();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    JfrLogConfiguration() {
    }

    void parse(String str) {
        if (str.equalsIgnoreCase("disable")) {
            return;
        }
        String config = str.isEmpty() ? EMPTY_STRING_DEFAULT_CONFIG : str;
        String[] splitConfig = config.split(",");
        JfrLogSelection[] selections = new JfrLogSelection[splitConfig.length];
        int index = 0;
        for (String s : splitConfig) {
            selections[index++] = JfrLogSelection.parse(s);
        }
        JfrLogConfiguration.setLogTagSetLevels(selections);
        JfrLogConfiguration.verifySelections(selections);
    }

    private static void setLogTagSetLevels(JfrLogSelection[] selections) {
        LogTag[] values;
        for (LogTag logTagSet : values = LogTag.values()) {
            JfrLogLevel logLevel = JfrLogLevel.WARNING;
            for (JfrLogSelection selection : selections) {
                if ((!selection.wildcard || !LOG_TAG_SETS.get((Object)logTagSet).containsAll(selection.tags)) && !selection.tags.equals(LOG_TAG_SETS.get((Object)logTagSet))) continue;
                logLevel = selection.level;
                selection.matchesATagSet = true;
            }
            SubstrateUtil.cast((Object)((Object)logTagSet), Target_jdk_jfr_internal_LogTag.class).tagSetLevel = logLevel.level;
        }
    }

    private static void verifySelections(JfrLogSelection[] selections) {
        for (JfrLogSelection selection : selections) {
            if (selection.matchesATagSet) continue;
            throw new IllegalArgumentException("No tag set matches tag combination " + selection.tags.toString().toLowerCase() + (selection.wildcard ? "*" : "") + " for FlightRecorderLogging");
        }
    }

    private static Map<LogTag, Set<JfrLogTag>> createLogTagSets() {
        EnumMap<LogTag, Set<JfrLogTag>> result = new EnumMap<LogTag, Set<JfrLogTag>>(LogTag.class);
        result.put(LogTag.JFR, EnumSet.of(JfrLogTag.JFR));
        result.put(LogTag.JFR_SYSTEM, EnumSet.of(JfrLogTag.JFR, JfrLogTag.SYSTEM));
        result.put(LogTag.JFR_SYSTEM_EVENT, EnumSet.of(JfrLogTag.JFR, JfrLogTag.SYSTEM, JfrLogTag.EVENT));
        result.put(LogTag.JFR_SYSTEM_SETTING, EnumSet.of(JfrLogTag.JFR, JfrLogTag.SYSTEM, JfrLogTag.SETTING));
        result.put(LogTag.JFR_SYSTEM_BYTECODE, EnumSet.of(JfrLogTag.JFR, JfrLogTag.SYSTEM, JfrLogTag.BYTECODE));
        result.put(LogTag.JFR_SYSTEM_PARSER, EnumSet.of(JfrLogTag.JFR, JfrLogTag.SYSTEM, JfrLogTag.PARSER));
        result.put(LogTag.JFR_SYSTEM_METADATA, EnumSet.of(JfrLogTag.JFR, JfrLogTag.SYSTEM, JfrLogTag.METADATA));
        result.put(LogTag.JFR_METADATA, EnumSet.of(JfrLogTag.JFR, JfrLogTag.METADATA));
        result.put(LogTag.JFR_EVENT, EnumSet.of(JfrLogTag.JFR, JfrLogTag.EVENT));
        result.put(LogTag.JFR_SETTING, EnumSet.of(JfrLogTag.JFR, JfrLogTag.SETTING));
        result.put(LogTag.JFR_DCMD, EnumSet.of(JfrLogTag.JFR, JfrLogTag.DCMD));
        if (JavaVersionUtil.JAVA_SPEC >= 17) {
            try {
                LogTag jfrSystemStreaming = Enum.valueOf(LogTag.class, "JFR_SYSTEM_STREAMING");
                LogTag jfrSystemThrottle = Enum.valueOf(LogTag.class, "JFR_SYSTEM_THROTTLE");
                result.put(jfrSystemStreaming, EnumSet.of(JfrLogTag.JFR, JfrLogTag.SYSTEM, JfrLogTag.STREAMING));
                result.put(jfrSystemThrottle, EnumSet.of(JfrLogTag.JFR, JfrLogTag.SYSTEM, JfrLogTag.THROTTLE));
                LogTag jfrStart = Enum.valueOf(LogTag.class, "JFR_START");
                result.put(jfrStart, EnumSet.of(JfrLogTag.JFR, JfrLogTag.START));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw VMError.shouldNotReachHere("Should be defined", e);
            }
        }
        return result;
    }

    public static enum JfrLogLevel {
        TRACE(JfrLogging.getLevel(LogLevel.TRACE)),
        DEBUG(JfrLogging.getLevel(LogLevel.DEBUG)),
        INFO(JfrLogging.getLevel(LogLevel.INFO)),
        WARNING(JfrLogging.getLevel(LogLevel.WARN)),
        ERROR(JfrLogging.getLevel(LogLevel.ERROR)),
        OFF(100);

        final int level;

        private JfrLogLevel(int level) {
            this.level = level;
        }
    }

    private static class JfrLogSelection {
        private final Set<JfrLogTag> tags;
        private final JfrLogLevel level;
        private final boolean wildcard;
        private boolean matchesATagSet;

        JfrLogSelection(Set<JfrLogTag> tags, JfrLogLevel level, boolean wildcard) {
            this.tags = tags;
            this.level = level;
            this.wildcard = wildcard;
            this.matchesATagSet = false;
        }

        private static JfrLogSelection parse(String str) {
            String tagsStr;
            EnumSet<JfrLogTag> tags = EnumSet.noneOf(JfrLogTag.class);
            JfrLogLevel level = JfrLogLevel.INFO;
            boolean wildcard = false;
            int equalsIndex = str.indexOf(61);
            if (equalsIndex > 0) {
                String value = str.substring(equalsIndex + 1);
                try {
                    level = JfrLogLevel.valueOf(value.toUpperCase());
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    throw new IllegalArgumentException("Invalid log level '" + value + "' for FlightRecorderLogging.", e);
                }
                tagsStr = str.substring(0, equalsIndex);
            } else {
                tagsStr = str;
            }
            if (tagsStr.equalsIgnoreCase("all")) {
                return new JfrLogSelection(tags, level, true);
            }
            if (tagsStr.endsWith("*")) {
                wildcard = true;
                tagsStr = tagsStr.substring(0, tagsStr.length() - 1);
            }
            for (String s : tagsStr.split("\\+")) {
                try {
                    tags.add(JfrLogTag.valueOf(s.toUpperCase()));
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    throw new IllegalArgumentException("Invalid log tag '" + s + "' for FlightRecorderLogging.", e);
                }
            }
            return new JfrLogSelection(tags, level, wildcard);
        }
    }
}

