/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;

public class ExecuteVMOperationEvent {
    @Uninterruptible(reason="Accesses a JFR buffer.")
    public static void emit(VMOperation vmOperation, IsolateThread requestingThread, long startTicks) {
        if (!HasJfrSupport.get()) {
            return;
        }
        if (SubstrateJVM.isRecording() && SubstrateJVM.get().isEnabled(JfrEvent.ExecuteVMOperation)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.ExecuteVMOperation);
            JfrNativeEventWriter.putLong(data, startTicks);
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks() - startTicks);
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putLong(data, vmOperation.getId() + 1);
            JfrNativeEventWriter.putBoolean(data, vmOperation.getCausesSafepoint());
            JfrNativeEventWriter.putBoolean(data, vmOperation.isBlocking());
            JfrNativeEventWriter.putThread(data, requestingThread);
            JfrNativeEventWriter.putLong(data, vmOperation.getCausesSafepoint() ? Safepoint.Master.singleton().getSafepointId().rawValue() : 0L);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

