/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import jdk.jfr.Event;
import jdk.jfr.Name;
import jdk.jfr.Period;
import org.graalvm.nativeimage.StackValue;

@Name(value="EveryChunkPeriodEvents")
@Period(value="everyChunk")
public class EveryChunkNativePeriodicEvents
extends Event {
    public static void emit() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        EveryChunkNativePeriodicEvents.emitJavaThreadStats(threadMXBean.getThreadCount(), threadMXBean.getDaemonThreadCount(), threadMXBean.getTotalStartedThreadCount(), threadMXBean.getPeakThreadCount());
        EveryChunkNativePeriodicEvents.emitPhysicalMemory(PhysicalMemory.size().rawValue(), 0L);
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitJavaThreadStats(long activeCount, long daemonCount, long accumulatedCount, long peakCount) {
        if (SubstrateJVM.isRecording() && SubstrateJVM.get().isEnabled(JfrEvent.JavaThreadStatistics)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.JavaThreadStatistics);
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putLong(data, activeCount);
            JfrNativeEventWriter.putLong(data, daemonCount);
            JfrNativeEventWriter.putLong(data, accumulatedCount);
            JfrNativeEventWriter.putLong(data, peakCount);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitPhysicalMemory(long totalSize, long usedSize) {
        if (SubstrateJVM.isRecording() && SubstrateJVM.get().isEnabled(JfrEvent.PhysicalMemory)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.PhysicalMemory);
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putLong(data, totalSize);
            JfrNativeEventWriter.putLong(data, usedSize);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

