/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import jdk.internal.misc.Unsafe;
import jdk.jfr.internal.EventWriter;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JfrEventWriterAccess {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final Field startPosition = ReflectionUtil.lookupField(EventWriter.class, (String)"startPosition");
    private static final Field startPositionAddress = ReflectionUtil.lookupField(EventWriter.class, (String)"startPositionAddress");
    private static final Field currentPosition = ReflectionUtil.lookupField(EventWriter.class, (String)"currentPosition");
    private static final Field maxPosition = ReflectionUtil.lookupField(EventWriter.class, (String)"maxPosition");
    private static final Field valid = ReflectionUtil.lookupField(EventWriter.class, (String)"valid");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrEventWriterAccess() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setStartPosition(EventWriter writer, long value) {
        UNSAFE.putLong(writer, UNSAFE.objectFieldOffset(startPosition), value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setStartPositionAddress(EventWriter writer, long value) {
        UNSAFE.putLong(writer, UNSAFE.objectFieldOffset(startPositionAddress), value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setCurrentPosition(EventWriter writer, long value) {
        UNSAFE.putLong(writer, UNSAFE.objectFieldOffset(currentPosition), value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setMaxPosition(EventWriter writer, long value) {
        UNSAFE.putLong(writer, UNSAFE.objectFieldOffset(maxPosition), value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setValid(EventWriter writer, boolean value) {
        UNSAFE.putBooleanVolatile(writer, UNSAFE.objectFieldOffset(valid), value);
    }
}

