/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.JceSecurityAccessor;
import com.oracle.svm.core.jdk.JceSecurityUtil;
import com.oracle.svm.core.jdk.SecurityProvidersFilter;
import com.oracle.svm.core.util.VMError;
import java.net.URL;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Map;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

@TargetClass(className="javax.crypto.JceSecurity")
final class Target_javax_crypto_JceSecurity {
    @Alias
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    @InjectAccessors(value=JceSecurityAccessor.class)
    static SecureRandom RANDOM;
    @Alias
    private static Object PROVIDER_VERIFIED;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=VerificationCacheTransformer.class, disableCaching=true)
    private static Map<Object, Object> verificationResults;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static Map<Provider, Object> verifyingProviders;

    Target_javax_crypto_JceSecurity() {
    }

    @Substitute
    static void verifyProvider(URL codeBase, Provider p) {
        throw JceSecurityUtil.shouldNotReach("javax.crypto.JceSecurity.verifyProviderJar(URL, Provider)");
    }

    @Substitute
    static URL getCodeBase(Class<?> clazz) {
        throw VMError.unsupportedFeature("Trying to access the code base of " + clazz + ". ");
    }

    @Substitute
    static Exception getVerificationResult(Provider p) {
        Object o = verificationResults.get(JceSecurityUtil.providerKey(p));
        if (o == PROVIDER_VERIFIED) {
            return null;
        }
        if (o != null) {
            return (Exception)o;
        }
        throw VMError.unsupportedFeature("Trying to verify a provider that was not registered at build time: " + p + ". All providers must be registered and verified in the Native Image builder. ");
    }

    private static class VerificationCacheTransformer
    implements RecomputeFieldValue.CustomFieldValueTransformer {
        private VerificationCacheTransformer() {
        }

        @Override
        public RecomputeFieldValue.ValueAvailability valueAvailability() {
            return RecomputeFieldValue.ValueAvailability.BeforeAnalysis;
        }

        @Override
        public Object transform(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver, Object originalValue) {
            return SecurityProvidersFilter.instance().cleanVerificationCache(originalValue);
        }
    }
}

