/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.hub.Target_java_lang_Class_AnnotationData;
import com.oracle.svm.core.hub.Target_java_lang_Class_ReflectionData;
import com.oracle.svm.core.jdk.ProtectionDomainSupport;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.security.ProtectionDomain;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.generics.repository.ClassRepository;

public final class DynamicHubCompanion {
    private static final Object NO_CLASS_LOADER = new Object();
    private String packageName;
    private Object classLoader;
    private ProtectionDomain protectionDomain;
    private ClassRepository genericInfo;
    private SoftReference<Target_java_lang_Class_ReflectionData<?>> reflectionData;
    private AnnotationType annotationType;
    private Target_java_lang_Class_AnnotationData annotationData;
    private Constructor<?> cachedConstructor;
    private Class<?> newInstanceCallerCache;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    DynamicHubCompanion(Class<?> hostedJavaClass, ClassLoader classLoader) {
        this.classLoader = PredefinedClassesSupport.isPredefined(hostedJavaClass) ? NO_CLASS_LOADER : classLoader;
    }

    String getPackageName(DynamicHub hub) {
        if (this.packageName == null) {
            this.packageName = hub.computePackageName();
        }
        return this.packageName;
    }

    boolean hasClassLoader() {
        return this.classLoader != NO_CLASS_LOADER;
    }

    ClassLoader getClassLoader() {
        Object loader = this.classLoader;
        VMError.guarantee(loader != NO_CLASS_LOADER);
        return (ClassLoader)loader;
    }

    void setClassLoader(ClassLoader loader) {
        VMError.guarantee(this.classLoader == NO_CLASS_LOADER && loader != NO_CLASS_LOADER);
        this.classLoader = loader;
    }

    ProtectionDomain getProtectionDomain() {
        if (this.protectionDomain == null) {
            this.protectionDomain = ProtectionDomainSupport.allPermDomain();
        }
        return this.protectionDomain;
    }

    void setProtectionDomain(ProtectionDomain domain) {
        VMError.guarantee(this.protectionDomain == null && domain != null);
        this.protectionDomain = domain;
    }

    public ClassRepository getGenericInfo(DynamicHub hub) {
        if (this.genericInfo == null) {
            this.genericInfo = hub.computeGenericInfo();
        }
        return this.genericInfo != ClassRepository.NONE ? this.genericInfo : null;
    }

    SoftReference<Target_java_lang_Class_ReflectionData<?>> getReflectionData() {
        return this.reflectionData;
    }

    AnnotationType getAnnotationType() {
        return this.annotationType;
    }

    Target_java_lang_Class_AnnotationData getAnnotationData() {
        return this.annotationData;
    }

    Constructor<?> getCachedConstructor() {
        return this.cachedConstructor;
    }

    void setCachedConstructor(Constructor<?> constructor) {
        this.cachedConstructor = constructor;
    }

    Class<?> getNewInstanceCallerCache() {
        return this.newInstanceCallerCache;
    }

    void setNewInstanceCallerCache(Class<?> constructor) {
        this.newInstanceCallerCache = constructor;
    }
}

