/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.amd64.AMD64CalleeSavedRegisters;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.nativeimage.Platform;

public class SubstrateAMD64RegisterConfig
implements SubstrateRegisterConfig {
    private final TargetDescription target;
    private final int nativeParamsStackOffset;
    private final RegisterArray javaGeneralParameterRegs;
    private final RegisterArray nativeGeneralParameterRegs;
    private final RegisterArray xmmParameterRegs;
    private final RegisterArray allocatableRegs;
    private final RegisterArray calleeSaveRegisters;
    private final RegisterAttributes[] attributesMap;
    private final MetaAccessProvider metaAccess;
    private final boolean useBasePointer;
    private static final RegisterArray MASK_REGISTERS = new RegisterArray(new Register[]{AMD64.k0, AMD64.k1, AMD64.k2, AMD64.k3, AMD64.k4, AMD64.k5, AMD64.k6, AMD64.k7});

    public SubstrateAMD64RegisterConfig(SubstrateRegisterConfig.ConfigKind config, MetaAccessProvider metaAccess, TargetDescription target, boolean useBasePointer) {
        ArrayList regs;
        this.target = target;
        this.metaAccess = metaAccess;
        this.useBasePointer = useBasePointer;
        boolean haveAVX512 = ((AMD64)target.arch).getFeatures().contains(AMD64.CPUFeature.AVX512F);
        if (haveAVX512) {
            regs = new ArrayList(AMD64.valueRegistersAVX512.asList());
        } else {
            regs = new ArrayList(AMD64.valueRegistersSSE.asList());
            if (SubstrateUtil.HOSTED && AMD64CalleeSavedRegisters.isRuntimeCompilationEnabled()) {
                regs.addAll(MASK_REGISTERS.asList());
            }
        }
        if (Platform.includedIn(Platform.WINDOWS.class)) {
            this.nativeGeneralParameterRegs = new RegisterArray(new Register[]{AMD64.rcx, AMD64.rdx, AMD64.r8, AMD64.r9});
            this.javaGeneralParameterRegs = new RegisterArray(new Register[]{AMD64.rdx, AMD64.r8, AMD64.r9, AMD64.rdi, AMD64.rsi, AMD64.rcx});
            this.xmmParameterRegs = new RegisterArray(new Register[]{AMD64.xmm0, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3});
            this.nativeParamsStackOffset = 4 * target.wordSize;
            regs.remove(ReservedRegisters.singleton().getFrameRegister());
            regs.remove(AMD64.rbp);
            regs.remove(ReservedRegisters.singleton().getHeapBaseRegister());
            regs.remove(ReservedRegisters.singleton().getThreadRegister());
            this.allocatableRegs = new RegisterArray(regs);
        } else {
            this.nativeGeneralParameterRegs = this.javaGeneralParameterRegs = new RegisterArray(new Register[]{AMD64.rdi, AMD64.rsi, AMD64.rdx, AMD64.rcx, AMD64.r8, AMD64.r9});
            this.xmmParameterRegs = new RegisterArray(new Register[]{AMD64.xmm0, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3, AMD64.xmm4, AMD64.xmm5, AMD64.xmm6, AMD64.xmm7});
            this.nativeParamsStackOffset = 0;
            regs.remove(ReservedRegisters.singleton().getFrameRegister());
            if (useBasePointer) {
                regs.remove(AMD64.rbp);
            }
            regs.remove(ReservedRegisters.singleton().getHeapBaseRegister());
            regs.remove(ReservedRegisters.singleton().getThreadRegister());
            this.allocatableRegs = new RegisterArray(regs);
        }
        switch (config) {
            case NORMAL: {
                this.calleeSaveRegisters = new RegisterArray(new Register[0]);
                break;
            }
            case NATIVE_TO_JAVA: {
                if (Platform.includedIn(Platform.WINDOWS.class)) {
                    this.calleeSaveRegisters = new RegisterArray(new Register[]{AMD64.rbx, AMD64.rdi, AMD64.rsi, AMD64.r12, AMD64.r13, AMD64.r14, AMD64.r15, AMD64.rbp, AMD64.xmm6, AMD64.xmm7, AMD64.xmm8, AMD64.xmm9, AMD64.xmm10, AMD64.xmm11, AMD64.xmm12, AMD64.xmm13, AMD64.xmm14, AMD64.xmm15});
                    break;
                }
                this.calleeSaveRegisters = new RegisterArray(new Register[]{AMD64.rbx, AMD64.r12, AMD64.r13, AMD64.r14, AMD64.r15, AMD64.rbp});
                break;
            }
            default: {
                throw VMError.shouldNotReachHere();
            }
        }
        this.attributesMap = RegisterAttributes.createMap((RegisterConfig)this, (RegisterArray)AMD64.allRegisters);
    }

    public Register getReturnRegister(JavaKind kind) {
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: 
            case Int: 
            case Long: 
            case Object: {
                return AMD64.rax;
            }
            case Float: 
            case Double: {
                return AMD64.xmm0;
            }
            case Void: {
                return null;
            }
        }
        throw VMError.shouldNotReachHere();
    }

    public RegisterArray getAllocatableRegisters() {
        return this.allocatableRegs;
    }

    public RegisterArray getCalleeSaveRegisters() {
        return this.calleeSaveRegisters;
    }

    public RegisterArray getCallerSaveRegisters() {
        return this.getAllocatableRegisters();
    }

    public boolean areAllAllocatableRegistersCallerSaved() {
        return true;
    }

    public RegisterAttributes[] getAttributesMap() {
        return this.attributesMap;
    }

    public RegisterArray getCallingConventionRegisters(CallingConvention.Type t, JavaKind kind) {
        throw VMError.unimplemented();
    }

    public boolean shouldUseBasePointer() {
        return this.useBasePointer;
    }

    public CallingConvention getCallingConvention(CallingConvention.Type t, JavaType returnType, JavaType[] parameterTypes, ValueKindFactory<?> valueKindFactory) {
        SubstrateCallingConventionType type = (SubstrateCallingConventionType)t;
        boolean isEntryPoint = type.nativeABI() && !type.outgoing;
        AllocatableValue[] locations = new AllocatableValue[parameterTypes.length];
        int currentGeneral = 0;
        int currentXMM = 0;
        int currentStackOffset = type.nativeABI() ? this.nativeParamsStackOffset : this.target.wordSize;
        JavaKind[] kinds = new JavaKind[locations.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            JavaKind kind;
            kinds[i] = kind = ObjectLayout.getCallSignatureKind(isEntryPoint, (ResolvedJavaType)parameterTypes[i], this.metaAccess, this.target);
            if (type.nativeABI() && Platform.includedIn(Platform.WINDOWS.class)) {
                currentGeneral = i;
                currentXMM = i;
            }
            Register register = null;
            if (type.kind == SubstrateCallingConventionKind.ForwardReturnValue) {
                VMError.guarantee(i == 0, "Method with calling convention ForwardReturnValue cannot have more than one parameter");
                register = this.getReturnRegister(kind);
            } else {
                switch (kind) {
                    case Boolean: 
                    case Byte: 
                    case Char: 
                    case Short: 
                    case Int: 
                    case Long: 
                    case Object: {
                        RegisterArray registers;
                        RegisterArray registerArray = registers = type.nativeABI() ? this.nativeGeneralParameterRegs : this.javaGeneralParameterRegs;
                        if (currentGeneral >= registers.size()) break;
                        register = registers.get(currentGeneral++);
                        break;
                    }
                    case Float: 
                    case Double: {
                        if (currentXMM >= this.xmmParameterRegs.size()) break;
                        register = this.xmmParameterRegs.get(currentXMM++);
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHere();
                    }
                }
            }
            ValueKind paramValueKind = valueKindFactory.getValueKind(isEntryPoint ? kind : kind.getStackKind());
            if (register != null) {
                locations[i] = register.asValue(paramValueKind);
                continue;
            }
            locations[i] = StackSlot.get((ValueKind)paramValueKind, (int)currentStackOffset, (!type.outgoing ? 1 : 0) != 0);
            currentStackOffset += Math.max(paramValueKind.getPlatformKind().getSizeInBytes(), this.target.wordSize);
        }
        JavaKind returnKind = returnType == null ? JavaKind.Void : ObjectLayout.getCallSignatureKind(isEntryPoint, (ResolvedJavaType)returnType, this.metaAccess, this.target);
        AllocatableValue returnLocation = returnKind == JavaKind.Void ? Value.ILLEGAL : this.getReturnRegister(returnKind).asValue(valueKindFactory.getValueKind(returnKind.getStackKind()));
        return new SubstrateCallingConvention(type, kinds, currentStackOffset, returnLocation, locations);
    }

    public RegisterArray filterAllocatableRegisters(PlatformKind kind, RegisterArray registers) {
        ArrayList<Register> list = new ArrayList<Register>();
        for (Register reg : registers) {
            if (!this.target.arch.canStoreValue(reg.getRegisterCategory(), kind)) continue;
            list.add(reg);
        }
        return new RegisterArray(list);
    }
}

