/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal.nodes;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.replacements.AllocationSnippets;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public class FormatPodNode
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<FormatPodNode> TYPE = NodeClass.create(FormatPodNode.class);
    @Node.Input
    protected ValueNode memory;
    @Node.Input
    protected ValueNode hub;
    @Node.Input
    protected ValueNode arrayLength;
    @Node.Input
    protected ValueNode referenceMap;
    @Node.Input
    protected ValueNode rememberedSet;
    @Node.Input
    protected ValueNode unaligned;
    @Node.Input
    protected ValueNode fillContents;
    @Node.Input
    protected ValueNode fillStartOffset;
    private final boolean emitMemoryBarrier;

    public FormatPodNode(ValueNode memory, ValueNode hub, ValueNode arrayLength, ValueNode referenceMap, ValueNode rememberedSet, ValueNode unaligned, ValueNode fillContents, ValueNode fillStartOffset, boolean emitMemoryBarrier) {
        super(TYPE, StampFactory.objectNonNull());
        this.memory = memory;
        this.hub = hub;
        this.arrayLength = arrayLength;
        this.referenceMap = referenceMap;
        this.rememberedSet = rememberedSet;
        this.unaligned = unaligned;
        this.fillContents = fillContents;
        this.fillStartOffset = fillStartOffset;
        this.emitMemoryBarrier = emitMemoryBarrier;
    }

    public ValueNode getMemory() {
        return this.memory;
    }

    public ValueNode getHub() {
        return this.hub;
    }

    public ValueNode getArrayLength() {
        return this.arrayLength;
    }

    public ValueNode getReferenceMap() {
        return this.referenceMap;
    }

    public ValueNode getRememberedSet() {
        return this.rememberedSet;
    }

    public ValueNode getUnaligned() {
        return this.unaligned;
    }

    public ValueNode getFillContents() {
        return this.fillContents;
    }

    public ValueNode getFillStartOffset() {
        return this.fillStartOffset;
    }

    public boolean getEmitMemoryBarrier() {
        return this.emitMemoryBarrier;
    }

    @Node.NodeIntrinsic
    public static native Object formatPod(Pointer var0, Class<?> var1, int var2, byte[] var3, boolean var4, boolean var5, AllocationSnippets.FillContent var6, int var7, @Node.ConstantNodeParameter boolean var8);
}

