/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.genscavenge.AbstractImageHeapLayouter;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapAllocator;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapPartition;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.HostedImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.ImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.RuntimeImageHeapChunkWriter;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.graalvm.compiler.core.common.NumUtil;

public class ChunkedImageHeapLayouter
extends AbstractImageHeapLayouter<ChunkedImageHeapPartition> {
    private final ImageHeapInfo heapInfo;
    private final long startOffset;
    private final int nullRegionSize;
    private final long hugeObjectThreshold;
    private ChunkedImageHeapAllocator allocator;

    public ChunkedImageHeapLayouter(ImageHeapInfo heapInfo, long startOffset, int nullRegionSize) {
        assert (startOffset == 0L || startOffset >= (long)Heap.getHeap().getImageHeapOffsetInAddressSpace()) : "must be relative to the heap base";
        this.heapInfo = heapInfo;
        this.startOffset = startOffset;
        this.nullRegionSize = nullRegionSize;
        this.hugeObjectThreshold = HeapParameters.getLargeArrayThreshold().rawValue();
    }

    protected ChunkedImageHeapPartition[] createPartitionsArray(int count) {
        return new ChunkedImageHeapPartition[count];
    }

    @Override
    protected ChunkedImageHeapPartition createPartition(String name, boolean containsReferences, boolean writable, boolean hugeObjects) {
        return new ChunkedImageHeapPartition(name, writable, hugeObjects);
    }

    @Override
    protected long getHugeObjectThreshold() {
        return this.hugeObjectThreshold;
    }

    @Override
    protected ImageHeapLayoutInfo doLayout(ImageHeap imageHeap) {
        long position = this.startOffset + (long)this.nullRegionSize;
        this.allocator = new ChunkedImageHeapAllocator(imageHeap, position);
        for (ChunkedImageHeapPartition partition : (ChunkedImageHeapPartition[])this.getPartitions()) {
            partition.layout(this.allocator);
        }
        return this.populateInfoObjects(imageHeap.countDynamicHubs());
    }

    private ImageHeapLayoutInfo populateInfoObjects(int dynamicHubCount) {
        ChunkedImageHeapAllocator.UnalignedChunk chunk;
        long offsetOfFirstWritableAlignedChunk = ((ChunkedImageHeapPartition)this.getWritablePrimitive()).getStartOffset();
        for (ChunkedImageHeapAllocator.AlignedChunk chunk2 : this.allocator.getAlignedChunks()) {
            if (!chunk2.isWritable() || chunk2.getBegin() >= offsetOfFirstWritableAlignedChunk) continue;
            assert (offsetOfFirstWritableAlignedChunk <= chunk2.getEnd());
            offsetOfFirstWritableAlignedChunk = chunk2.getBegin();
            break;
        }
        long offsetOfFirstWritableUnalignedChunk = -1L;
        Iterator<ChunkedImageHeapAllocator.UnalignedChunk> iterator = this.allocator.getUnalignedChunks().iterator();
        if (iterator.hasNext() && (chunk = iterator.next()).isWritable()) {
            offsetOfFirstWritableUnalignedChunk = chunk.getBegin();
        }
        this.initializeHeapInfo(dynamicHubCount, offsetOfFirstWritableAlignedChunk, offsetOfFirstWritableUnalignedChunk);
        return this.createLayoutInfo(this.startOffset, offsetOfFirstWritableAlignedChunk);
    }

    private void initializeHeapInfo(int dynamicHubCount, long offsetOfFirstWritableAlignedChunk, long offsetOfFirstWritableUnalignedChunk) {
        long writableAligned = offsetOfFirstWritableAlignedChunk;
        long writableUnaligned = offsetOfFirstWritableUnalignedChunk;
        if (this.startOffset == 0L) {
            int imageHeapOffsetInAddressSpace = Heap.getHeap().getImageHeapOffsetInAddressSpace();
            writableAligned += (long)imageHeapOffsetInAddressSpace;
            if (writableUnaligned >= 0L) {
                writableUnaligned += (long)imageHeapOffsetInAddressSpace;
            }
        }
        this.heapInfo.initialize(((ChunkedImageHeapPartition)this.getReadOnlyPrimitive()).firstObject, ((ChunkedImageHeapPartition)this.getReadOnlyPrimitive()).lastObject, ((ChunkedImageHeapPartition)this.getReadOnlyReference()).firstObject, ((ChunkedImageHeapPartition)this.getReadOnlyReference()).lastObject, ((ChunkedImageHeapPartition)this.getReadOnlyRelocatable()).firstObject, ((ChunkedImageHeapPartition)this.getReadOnlyRelocatable()).lastObject, ((ChunkedImageHeapPartition)this.getWritablePrimitive()).firstObject, ((ChunkedImageHeapPartition)this.getWritablePrimitive()).lastObject, ((ChunkedImageHeapPartition)this.getWritableReference()).firstObject, ((ChunkedImageHeapPartition)this.getWritableReference()).lastObject, ((ChunkedImageHeapPartition)this.getWritableHuge()).firstObject, ((ChunkedImageHeapPartition)this.getWritableHuge()).lastObject, ((ChunkedImageHeapPartition)this.getReadOnlyHuge()).firstObject, ((ChunkedImageHeapPartition)this.getReadOnlyHuge()).lastObject, writableAligned, writableUnaligned, dynamicHubCount);
    }

    @Override
    public void writeMetadata(ByteBuffer imageHeapBytes, long imageHeapOffsetInBuffer) {
        long layoutToBufferOffsetAddend = imageHeapOffsetInBuffer - this.startOffset;
        ImageHeapChunkWriter writer = SubstrateUtil.HOSTED ? new HostedImageHeapChunkWriter(imageHeapBytes, layoutToBufferOffsetAddend) : new RuntimeImageHeapChunkWriter(imageHeapBytes, layoutToBufferOffsetAddend);
        ChunkedImageHeapLayouter.writeHeaders(writer, this.allocator.getAlignedChunks());
        ChunkedImageHeapLayouter.writeHeaders(writer, this.allocator.getUnalignedChunks());
    }

    private static void writeHeaders(ImageHeapChunkWriter writer, List<? extends ChunkedImageHeapAllocator.Chunk> chunks) {
        ChunkedImageHeapAllocator.Chunk previous = null;
        ChunkedImageHeapAllocator.Chunk current = null;
        for (ChunkedImageHeapAllocator.Chunk chunk : chunks) {
            ChunkedImageHeapLayouter.writeHeader(writer, previous, current, chunk);
            previous = current;
            current = chunk;
        }
        ChunkedImageHeapLayouter.writeHeader(writer, previous, current, null);
    }

    private static void writeHeader(ImageHeapChunkWriter writer, ChunkedImageHeapAllocator.Chunk previous, ChunkedImageHeapAllocator.Chunk current, ChunkedImageHeapAllocator.Chunk next) {
        if (current != null) {
            long offsetToPrevious = previous != null ? previous.getBegin() - current.getBegin() : 0L;
            long offsetToNext = next != null ? next.getBegin() - current.getBegin() : 0L;
            int chunkPosition = NumUtil.safeToInt((long)current.getBegin());
            if (current instanceof ChunkedImageHeapAllocator.AlignedChunk) {
                ChunkedImageHeapAllocator.AlignedChunk aligned = (ChunkedImageHeapAllocator.AlignedChunk)current;
                writer.initializeAlignedChunk(chunkPosition, current.getTopOffset(), current.getEndOffset(), offsetToPrevious, offsetToNext);
                writer.enableRememberedSetForAlignedChunk(chunkPosition, aligned.getObjects());
            } else {
                assert (current instanceof ChunkedImageHeapAllocator.UnalignedChunk);
                writer.initializeUnalignedChunk(chunkPosition, current.getTopOffset(), current.getEndOffset(), offsetToPrevious, offsetToNext);
                writer.enableRememberedSetForUnalignedChunk(chunkPosition);
            }
        }
    }
}

