/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers.cgroupv2;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.containers.CgroupSubsystem;
import com.oracle.svm.core.containers.CgroupSubsystemController;
import com.oracle.svm.core.containers.CgroupUtil;
import com.oracle.svm.core.containers.cgroupv2.CgroupV2SubsystemController;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class CgroupV2Subsystem
implements CgroupSubsystem {
    private static final CgroupV2Subsystem INSTANCE = CgroupV2Subsystem.initSubsystem();
    private static final long[] LONG_ARRAY_NOT_SUPPORTED = null;
    private static final int[] INT_ARRAY_UNAVAILABLE = null;
    private final CgroupSubsystemController unified;
    private static final String PROVIDER_NAME = "cgroupv2";
    private static final int PER_CPU_SHARES = 1024;
    private static final String MAX_VAL = "max";
    private static final Object EMPTY_STR = "";

    private CgroupV2Subsystem(CgroupSubsystemController unified) {
        this.unified = unified;
    }

    private long getLongVal(String file) {
        return CgroupSubsystemController.getLongValue(this.unified, file, CgroupV2SubsystemController::convertStringToLong, -1L);
    }

    private static CgroupV2Subsystem initSubsystem() {
        String mountPath = null;
        try {
            for (String line : CgroupUtil.readAllLinesPrivileged(Paths.get("/proc/self/mountinfo", new String[0]))) {
                if (!line.contains(" - cgroup2 ")) continue;
                String[] tokens = SubstrateUtil.split(line, " ");
                mountPath = tokens[4];
            }
        }
        catch (IOException e) {
            return null;
        }
        String cgroupPath = null;
        try {
            List<String> lines = CgroupUtil.readAllLinesPrivileged(Paths.get("/proc/self/cgroup", new String[0]));
            Iterator<String> iterator = lines.iterator();
            if (iterator.hasNext()) {
                String line = iterator.next();
                String[] tokens = SubstrateUtil.split(line, ":");
                if (tokens.length != 3) {
                    return null;
                }
                if (!"0".equals(tokens[0])) {
                    return null;
                }
                cgroupPath = tokens[2];
            }
        }
        catch (IOException e) {
            return null;
        }
        CgroupV2SubsystemController unified = new CgroupV2SubsystemController(mountPath, cgroupPath);
        return new CgroupV2Subsystem(unified);
    }

    public static CgroupSubsystem getInstance() {
        return INSTANCE;
    }

    @Override
    public String getProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public long getCpuUsage() {
        long micros = CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "usage_usec");
        if (micros < 0L) {
            return micros;
        }
        return TimeUnit.MICROSECONDS.toNanos(micros);
    }

    @Override
    public long[] getPerCpuUsage() {
        return LONG_ARRAY_NOT_SUPPORTED;
    }

    @Override
    public long getCpuUserUsage() {
        long micros = CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "user_usec");
        if (micros < 0L) {
            return micros;
        }
        return TimeUnit.MICROSECONDS.toNanos(micros);
    }

    @Override
    public long getCpuSystemUsage() {
        long micros = CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "system_usec");
        if (micros < 0L) {
            return micros;
        }
        return TimeUnit.MICROSECONDS.toNanos(micros);
    }

    @Override
    public long getCpuPeriod() {
        return this.getFromCpuMax(1);
    }

    @Override
    public long getCpuQuota() {
        return this.getFromCpuMax(0);
    }

    private long getFromCpuMax(int tokenIdx) {
        String cpuMaxRaw = CgroupSubsystemController.getStringValue(this.unified, "cpu.max");
        if (cpuMaxRaw == null) {
            return -1L;
        }
        String[] tokens = SubstrateUtil.split(cpuMaxRaw, " ");
        if (tokens.length != 2) {
            return -1L;
        }
        String quota = tokens[tokenIdx];
        return this.limitFromString(quota);
    }

    private long limitFromString(String strVal) {
        if (strVal == null || MAX_VAL.equals(strVal)) {
            return -1L;
        }
        return Long.parseLong(strVal);
    }

    @Override
    public long getCpuShares() {
        int distance_upper;
        long sharesRaw = this.getLongVal("cpu.weight");
        if (sharesRaw == 100L || sharesRaw <= 0L) {
            return -1L;
        }
        int shares = (int)sharesRaw;
        int x = 262142 * shares - 1;
        double frac = (double)x / 9999.0;
        if ((x = (int)frac + 2) <= 1024) {
            return 1024L;
        }
        int f = x / 1024;
        int lower_multiple = f * 1024;
        int upper_multiple = (f + 1) * 1024;
        int distance_lower = Math.max(lower_multiple, x) - Math.min(lower_multiple, x);
        x = distance_lower <= (distance_upper = Math.max(upper_multiple, x) - Math.min(upper_multiple, x)) ? lower_multiple : upper_multiple;
        return x;
    }

    @Override
    public long getCpuNumPeriods() {
        return CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "nr_periods");
    }

    @Override
    public long getCpuNumThrottled() {
        return CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "nr_throttled");
    }

    @Override
    public long getCpuThrottledTime() {
        long micros = CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "throttled_usec");
        if (micros < 0L) {
            return micros;
        }
        return TimeUnit.MICROSECONDS.toNanos(micros);
    }

    @Override
    public long getEffectiveCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int[] getCpuSetCpus() {
        String cpuSetVal = CgroupSubsystemController.getStringValue(this.unified, "cpuset.cpus");
        return this.getCpuSet(cpuSetVal);
    }

    @Override
    public int[] getEffectiveCpuSetCpus() {
        String effCpuSetVal = CgroupSubsystemController.getStringValue(this.unified, "cpuset.cpus.effective");
        return this.getCpuSet(effCpuSetVal);
    }

    @Override
    public int[] getCpuSetMems() {
        String cpuSetMems = CgroupSubsystemController.getStringValue(this.unified, "cpuset.mems");
        return this.getCpuSet(cpuSetMems);
    }

    @Override
    public int[] getEffectiveCpuSetMems() {
        String effCpuSetMems = CgroupSubsystemController.getStringValue(this.unified, "cpuset.mems.effective");
        return this.getCpuSet(effCpuSetMems);
    }

    private int[] getCpuSet(String cpuSetVal) {
        if (cpuSetVal == null || EMPTY_STR.equals(cpuSetVal)) {
            return INT_ARRAY_UNAVAILABLE;
        }
        return CgroupSubsystemController.stringRangeToIntArray(cpuSetVal);
    }

    @Override
    public long getMemoryFailCount() {
        return CgroupV2SubsystemController.getLongEntry(this.unified, "memory.events", MAX_VAL);
    }

    @Override
    public long getMemoryLimit() {
        String strVal = CgroupSubsystemController.getStringValue(this.unified, "memory.max");
        return this.limitFromString(strVal);
    }

    @Override
    public long getMemoryUsage() {
        return this.getLongVal("memory.current");
    }

    @Override
    public long getTcpMemoryUsage() {
        return CgroupV2SubsystemController.getLongEntry(this.unified, "memory.stat", "sock");
    }

    @Override
    public long getMemoryAndSwapLimit() {
        String strVal = CgroupSubsystemController.getStringValue(this.unified, "memory.swap.max");
        return this.limitFromString(strVal);
    }

    @Override
    public long getMemoryAndSwapUsage() {
        return this.getLongVal("memory.swap.current");
    }

    @Override
    public long getMemorySoftLimit() {
        String softLimitStr = CgroupSubsystemController.getStringValue(this.unified, "memory.high");
        return this.limitFromString(softLimitStr);
    }

    @Override
    public long getBlkIOServiceCount() {
        return this.sumTokensIOStat(CgroupV2Subsystem::lineToRandWIOs);
    }

    @Override
    public long getBlkIOServiced() {
        return this.sumTokensIOStat(CgroupV2Subsystem::lineToRBytesAndWBytesIO);
    }

    private long sumTokensIOStat(Function<String, Long> mapFunc) {
        try {
            long sum = 0L;
            for (String line : CgroupUtil.readAllLinesPrivileged(Paths.get(this.unified.path(), "io.stat"))) {
                sum += mapFunc.apply(line).longValue();
            }
            return sum;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private static String[] getRWIOMatchTokenNames() {
        return new String[]{"rios", "wios"};
    }

    private static String[] getRWBytesIOMatchTokenNames() {
        return new String[]{"rbytes", "wbytes"};
    }

    public static Long lineToRandWIOs(String line) {
        String[] matchNames = CgroupV2Subsystem.getRWIOMatchTokenNames();
        return CgroupV2Subsystem.ioStatLineToLong(line, matchNames);
    }

    public static Long lineToRBytesAndWBytesIO(String line) {
        String[] matchNames = CgroupV2Subsystem.getRWBytesIOMatchTokenNames();
        return CgroupV2Subsystem.ioStatLineToLong(line, matchNames);
    }

    private static Long ioStatLineToLong(String line, String[] matchNames) {
        if (line == null || EMPTY_STR.equals(line)) {
            return 0L;
        }
        String[] tokens = SubstrateUtil.split(line, " ");
        long retval = 0L;
        for (String t : tokens) {
            String[] valKeys = SubstrateUtil.split(t, "=");
            if (valKeys.length != 2) continue;
            for (String match : matchNames) {
                if (!match.equals(valKeys[0])) continue;
                retval += CgroupV2Subsystem.longOrZero(valKeys[1]);
            }
        }
        return retval;
    }

    private static long longOrZero(String val) {
        long lVal = 0L;
        try {
            lVal = Long.parseLong(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return lVal;
    }
}

