/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.CodeInfoTether;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public class AbstractRuntimeCodeInstaller {
    protected Pointer allocateCodeMemory(long size) {
        CodePointer result = RuntimeCodeInfoAccess.allocateCodeMemory(WordFactory.unsigned((long)size));
        if (result.isNull()) {
            throw new OutOfMemoryError();
        }
        return (Pointer)result;
    }

    protected void makeCodeMemoryReadOnly(Pointer start, long size) {
        RuntimeCodeInfoAccess.makeCodeMemoryExecutableReadOnly((CodePointer)start, WordFactory.unsigned((long)size));
    }

    protected void makeCodeMemoryWriteableNonExecutable(Pointer start, long size) {
        RuntimeCodeInfoAccess.makeCodeMemoryWriteableNonExecutable((CodePointer)start, WordFactory.unsigned((long)size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doInstallPrepared(SharedMethod method, CodeInfo codeInfo, SubstrateInstalledCode installedCode) {
        CodeInfoTether tether = RuntimeCodeInfoAccess.beforeInstallInCurrentIsolate(codeInfo, installedCode);
        try {
            AbstractRuntimeCodeInstaller.doInstallPreparedAndTethered(method, codeInfo, installedCode);
        }
        finally {
            CodeInfoAccess.releaseTether(codeInfo, tether);
        }
    }

    protected static void doInstallPreparedAndTethered(SharedMethod method, CodeInfo codeInfo, SubstrateInstalledCode installedCode) {
        InstallCodeOperation vmOp = new InstallCodeOperation(method, codeInfo, installedCode);
        vmOp.enqueue();
        if (vmOp.error != null) {
            throw AbstractRuntimeCodeInstaller.rethrow(vmOp.error);
        }
    }

    protected static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    protected static RuntimeCodeInstallerPlatformHelper platformHelper() {
        return (RuntimeCodeInstallerPlatformHelper)ImageSingletons.lookup(RuntimeCodeInstallerPlatformHelper.class);
    }

    public static interface RuntimeCodeInstallerPlatformHelper {
        public void performCodeSynchronization(CodeInfo var1);
    }

    private static class InstallCodeOperation
    extends JavaVMOperation {
        private final SharedMethod method;
        private final CodeInfo codeInfo;
        private final SubstrateInstalledCode installedCode;
        private Throwable error;

        InstallCodeOperation(SharedMethod method, CodeInfo codeInfo, SubstrateInstalledCode installedCode) {
            super(VMOperationInfos.get(InstallCodeOperation.class, "Install code", VMOperation.SystemEffect.SAFEPOINT));
            this.method = method;
            this.codeInfo = codeInfo;
            this.installedCode = installedCode;
        }

        @Override
        protected void operate() {
            try {
                assert (!this.installedCode.isValid() && !this.installedCode.isAlive());
                CodePointer codeStart = CodeInfoAccess.getCodeStart(this.codeInfo);
                this.installedCode.setAddress(codeStart.rawValue(), this.method);
                CodeInfoTable.getRuntimeCodeCache().addMethod(this.codeInfo);
                AbstractRuntimeCodeInstaller.platformHelper().performCodeSynchronization(this.codeInfo);
                VMError.guarantee(CodeInfoAccess.getState(this.codeInfo) == 1 && this.installedCode.isValid(), "The code can't be invalidated before the VM operation finishes");
            }
            catch (Throwable e) {
                this.error = e;
            }
        }
    }
}

