/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.meta.SharedMethod;
import java.lang.reflect.AnnotatedElement;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.util.DirectAnnotationAccess;

public class MethodSafepointInsertionPhase
extends BasePhase<MidTierContext> {
    public boolean checkContract() {
        return false;
    }

    public static boolean needSafepointCheck(SharedMethod method) {
        if (method.isUninterruptible()) {
            return false;
        }
        return !DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)method), CFunction.class) && !DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)method), InvokeCFunctionPointer.class);
    }

    protected void run(StructuredGraph graph, MidTierContext context) {
        SharedMethod method = (SharedMethod)graph.method();
        if (((SubstrateBackend)context.getTargetProvider()).safepointCheckedInEpilogue(method) || !MethodSafepointInsertionPhase.needSafepointCheck(method)) {
            return;
        }
        for (ReturnNode returnNode : graph.getNodes(ReturnNode.TYPE)) {
            SafepointNode safepointNode = (SafepointNode)graph.add((Node)new SafepointNode());
            graph.addBeforeFixed((FixedNode)returnNode, (FixedWithNextNode)safepointNode);
        }
    }
}

