/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hosted.GraalFeature;
import com.oracle.svm.graal.hosted.GraalObjectReplacer;
import com.oracle.svm.graal.meta.SubstrateType;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeCloneable;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.vm.ci.meta.JavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class NodeClassFeature
implements Feature {
    private AnalysisMetaAccess metaAccess;
    private GraalObjectReplacer graalObjectReplacer;
    private final Set<Class<?>> registeredClasses = new HashSet();

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(TruffleFeature.class, GraalFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        this.metaAccess = ((FeatureImpl.DuringSetupAccessImpl)access).getMetaAccess();
        this.graalObjectReplacer = ((GraalFeature)ImageSingletons.lookup(GraalFeature.class)).getObjectReplacer();
        access.registerObjectReplacer(this::replaceNodeFieldAccessor);
    }

    private Object replaceNodeFieldAccessor(Object source) {
        if (source instanceof NodeFieldAccessor || source instanceof NodeFieldAccessor[] && ((NodeFieldAccessor[])source).length > 0) {
            throw VMError.shouldNotReachHere("Cannot have NodeFieldAccessor in image, they must be created lazily");
        }
        if (source instanceof NodeClass && !(source instanceof SubstrateType)) {
            NodeClass nodeClass = (NodeClass)source;
            SubstrateType replacement = this.graalObjectReplacer.createType((JavaType)this.metaAccess.lookupJavaType(nodeClass.getType()));
            assert (replacement != null);
            return replacement;
        }
        return source;
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        for (Class clazz : access.reachableSubtypes(Node.class)) {
            this.registerUnsafeAccess(access, clazz.asSubclass(Node.class));
            AnalysisType type = ((FeatureImpl.DuringAnalysisAccessImpl)access).getMetaAccess().lookupJavaType(clazz);
            if (!type.isInstantiated()) continue;
            this.graalObjectReplacer.createType((JavaType)type);
        }
    }

    private void registerUnsafeAccess(Feature.DuringAnalysisAccess access, Class<? extends Node> clazz) {
        if (this.registeredClasses.contains(clazz)) {
            return;
        }
        this.registeredClasses.add(clazz);
        NodeClass nodeClass = NodeClass.get(clazz);
        for (NodeFieldAccessor accessor : nodeClass.getFields()) {
            Field field;
            try {
                field = accessor.getDeclaringClass().getDeclaredField(accessor.getName());
            }
            catch (NoSuchFieldException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
            if (accessor.getKind() == NodeFieldAccessor.NodeFieldKind.PARENT || accessor.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD || accessor.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN) {
                access.registerAsUnsafeAccessed(field);
            }
            if (accessor.getKind() == NodeFieldAccessor.NodeFieldKind.DATA && NodeCloneable.class.isAssignableFrom(accessor.getType())) {
                access.registerAsUnsafeAccessed(field);
            }
            access.registerAsAccessed(field);
        }
        access.requireAnalysisIteration();
    }
}

