/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.option;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Field;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class HostedOptionFeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        accessImpl.registerAsUsed(SubstrateGCOptions.class);
        HostedOptionFeature.registerOptionAsRead(accessImpl, SubstrateGCOptions.class, SubstrateGCOptions.MaxHeapSize.getName());
        HostedOptionFeature.registerOptionAsRead(accessImpl, SubstrateGCOptions.class, SubstrateGCOptions.MinHeapSize.getName());
        HostedOptionFeature.registerOptionAsRead(accessImpl, SubstrateGCOptions.class, SubstrateGCOptions.MaxNewSize.getName());
        HostedOptionFeature.registerOptionAsRead(accessImpl, SubstrateOptions.class, SubstrateOptions.StackSize.getName());
    }

    private static void registerOptionAsRead(FeatureImpl.BeforeAnalysisAccessImpl accessImpl, Class<?> clazz, String fieldName) {
        try {
            Field javaField = clazz.getField(fieldName);
            AnalysisField analysisField = accessImpl.getMetaAccess().lookupJavaField(javaField);
            accessImpl.registerAsRead(analysisField);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }
}

