/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.compiler.core.common.calc.UnsignedMath;

public class TypeCheckBuilder {
    private static final int SLOT_CAPACITY = 65536;
    private final HostedType objectType;
    private final List<HostedType> allTypes;
    private Set<HostedType> allIncludedTypes;
    private List<HostedType> allIncludedRoots;
    private List<HostedType> heightOrderedTypes;
    private int numTypeCheckSlots = -1;
    private Map<HostedType, List<HostedType>> subtypeMap = new HashMap<HostedType, List<HostedType>>();

    public TypeCheckBuilder(List<HostedType> types, HostedType objectType) {
        this.allTypes = types;
        this.objectType = objectType;
    }

    public int getNumTypeCheckSlots() {
        assert (this.numTypeCheckSlots != -1);
        return this.numTypeCheckSlots;
    }

    private static boolean shouldIncludeType(HostedType type) {
        return type.getWrapped().isReachable();
    }

    private static boolean isInterface(HostedType type) {
        return type.isInterface() || type.isArray() && type.getBaseType().isInterface();
    }

    private static short getShortValue(int intValue) {
        assert (intValue < 65536);
        return (short)intValue;
    }

    public boolean calculateIDs() {
        this.computeMetadata();
        ClassIDBuilder classBuilder = new ClassIDBuilder(this.objectType, this.allIncludedRoots, this.heightOrderedTypes, this.subtypeMap);
        classBuilder.computeSlots();
        InterfaceIDBuilder interfaceBuilder = new InterfaceIDBuilder(classBuilder.numClassSlots, this.heightOrderedTypes, this.subtypeMap);
        interfaceBuilder.computeSlots();
        this.generateTypeCheckSlots(classBuilder, interfaceBuilder);
        assert (TypeCheckValidator.compareTypeIDResults(this.heightOrderedTypes));
        return true;
    }

    private void computeMetadata() {
        this.allIncludedTypes = this.allTypes.stream().filter(t -> TypeCheckBuilder.shouldIncludeType(t)).collect(Collectors.toSet());
        this.computeSubtypeInformation();
        HashMap<HostedType, Set> parentMap = new HashMap<HostedType, Set>();
        for (HostedType type : this.allIncludedTypes) {
            for (HostedType subtype : this.subtypeMap.get(type)) {
                assert (TypeCheckBuilder.shouldIncludeType(subtype));
                parentMap.computeIfAbsent(subtype, k -> new HashSet()).add(type);
            }
        }
        this.allIncludedRoots = this.allIncludedTypes.stream().filter(t -> !parentMap.containsKey(t)).collect(Collectors.toList());
        this.heightOrderedTypes = this.generateHeightOrder(this.allIncludedRoots);
    }

    private List<HostedType> generateHeightOrder(List<HostedType> roots) {
        HashMap<HostedType, Integer> heightMap = new HashMap<HostedType, Integer>();
        this.allIncludedTypes.forEach(t -> heightMap.put((HostedType)t, Integer.MIN_VALUE));
        for (HostedType root : roots) {
            this.generateHeightOrderHelper(0, root, heightMap);
        }
        return this.allIncludedTypes.stream().sorted(Comparator.comparingInt(heightMap::get)).collect(Collectors.toList());
    }

    private void generateHeightOrderHelper(int depth, HostedType node, Map<HostedType, Integer> heightMap) {
        assert (TypeCheckBuilder.shouldIncludeType(node));
        heightMap.compute(node, (k, currentHeight) -> Integer.max(depth, currentHeight));
        for (HostedType subtype : this.subtypeMap.get(node)) {
            this.generateHeightOrderHelper(depth + 1, subtype, heightMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void computeSubtypeInformation() {
        HashMap allTypeCheckSubTypes = new HashMap();
        this.allIncludedTypes.stream().forEach(t -> {
            Set cfr_ignored_0 = allTypeCheckSubTypes.put(t, new HashSet());
        });
        HashSet<HostedType> descendantsToCompute = new HashSet<HostedType>();
        for (HostedType type : this.allIncludedTypes) {
            if (type.getSuperclass() != null) {
                void var5_14;
                if (!type.isArray()) {
                    HostedClass hostedClass = type.getSuperclass();
                } else {
                    HostedType baseType = type.getBaseType();
                    int dim = type.getArrayDimension();
                    assert (dim >= 1);
                    if (baseType.isInterface()) {
                        HostedType hostedType = this.getHighestDimArrayType(this.objectType, dim);
                        descendantsToCompute.add(baseType);
                    } else if (baseType.isPrimitive()) {
                        HostedType hostedType = this.getHighestDimArrayType(this.objectType, dim - 1);
                    } else {
                        HostedClass baseSuperClass = baseType.getSuperclass();
                        if (baseSuperClass == null) {
                            HostedType hostedType = this.getHighestDimArrayType(this.objectType, dim - 1);
                        } else {
                            void var5_11;
                            HostedType hostedType = baseSuperClass.getArrayClass(dim);
                            while (!this.isTypeIncluded((HostedType)var5_11)) {
                                if ((baseSuperClass = baseSuperClass.getSuperclass()) == null) {
                                    HostedType hostedType2 = this.getHighestDimArrayType(this.objectType, dim - 1);
                                    continue;
                                }
                                HostedType hostedType3 = baseSuperClass.getArrayClass(dim);
                            }
                        }
                    }
                }
                ((Set)allTypeCheckSubTypes.get(var5_14)).add(type);
            }
            if (type.isInterface()) {
                assert (type.getSuperclass() == null);
                ((Set)allTypeCheckSubTypes.get(this.objectType)).add(type);
            }
            for (HostedInterface interfaceType : type.getInterfaces()) {
                if (!type.isArray()) {
                    ((Set)allTypeCheckSubTypes.get(interfaceType)).add(type);
                    continue;
                }
                int dim = type.getArrayDimension();
                HostedType baseType = interfaceType.getBaseType();
                HostedType arrayInterfaceType = this.getHighestDimArrayType(baseType, dim - 1);
                ((Set)allTypeCheckSubTypes.get(arrayInterfaceType)).add(type);
            }
        }
        Map<HostedType, Set<HostedType>> descendantsMap = this.computeNonArrayDescendants(descendantsToCompute);
        for (HostedType hostedType : this.allIncludedTypes) {
            Set typeCheckSubTypeSet = (Set)allTypeCheckSubTypes.get(hostedType);
            if (hostedType.isArray() && hostedType.getBaseType().isInterface()) {
                int dim = hostedType.getArrayDimension();
                assert (dim >= 1);
                Set<HostedType> descendants = descendantsMap.get(hostedType.getBaseType());
                for (HostedType descendant : descendants) {
                    assert (!descendant.isArray());
                    HostedType arrayDescendant = descendant.getArrayClass(dim);
                    if (!this.isTypeIncluded(arrayDescendant)) continue;
                    typeCheckSubTypeSet.add(arrayDescendant);
                }
            }
            List typeCheckSubTypes = typeCheckSubTypeSet.stream().sorted().collect(Collectors.toList());
            this.subtypeMap.put(hostedType, typeCheckSubTypes);
        }
    }

    private boolean isTypeIncluded(HostedType type) {
        return type != null && this.allIncludedTypes.contains(type);
    }

    private HostedType getHighestDimArrayType(HostedType type, int dimMax) {
        HostedType result;
        assert (type != null);
        int dim = dimMax;
        do {
            result = type.getArrayClass(dim);
            --dim;
        } while (!this.isTypeIncluded(result));
        return result;
    }

    private Map<HostedType, Set<HostedType>> computeNonArrayDescendants(Set<HostedType> types) {
        HashMap<HostedType, Set<HostedType>> descendantsMap = new HashMap<HostedType, Set<HostedType>>();
        for (HostedType type : types) {
            this.computeNonArrayDescendantsHelper(type, descendantsMap);
        }
        return descendantsMap;
    }

    private void computeNonArrayDescendantsHelper(HostedType type, Map<HostedType, Set<HostedType>> descendantsMap) {
        if (descendantsMap.containsKey(type)) {
            return;
        }
        HashSet<HostedType> descendants = new HashSet<HostedType>();
        for (HostedType child : type.subTypes) {
            if (child.isArray()) continue;
            descendants.add(child);
            this.computeNonArrayDescendantsHelper(child, descendantsMap);
            descendants.addAll((Collection)descendantsMap.get(child));
        }
        descendantsMap.put(type, descendants);
    }

    private void generateTypeCheckSlots(ClassIDBuilder classBuilder, InterfaceIDBuilder interfaceBuilder) {
        int numClassSlots = classBuilder.numClassSlots;
        this.numTypeCheckSlots = numClassSlots + interfaceBuilder.numInterfaceSlots;
        int numSlots = this.getNumTypeCheckSlots();
        for (HostedType type : this.allIncludedTypes) {
            int i;
            short[] typeCheckSlots = new short[numSlots];
            int[] slots = classBuilder.classSlotIDMap.get(type);
            for (i = 0; i < slots.length; ++i) {
                typeCheckSlots[i] = TypeCheckBuilder.getShortValue(slots[i]);
                assert (typeCheckSlots[i] < 65536);
            }
            slots = interfaceBuilder.interfaceSlotIDMap.get(type);
            if (slots != null) {
                for (i = 0; i < slots.length; ++i) {
                    typeCheckSlots[numClassSlots + i] = TypeCheckBuilder.getShortValue(slots[i]);
                    assert (typeCheckSlots[numClassSlots + i] < 65536);
                }
            }
            type.setTypeCheckSlots(typeCheckSlots);
        }
    }

    private static final class TypeCheckValidator {
        private TypeCheckValidator() {
        }

        static boolean compareTypeIDResults(List<HostedType> types) {
            int numTypes = types.size();
            for (int i = 0; i < numTypes; ++i) {
                HostedType superType = types.get(i);
                for (int j = 0; j < numTypes; ++j) {
                    boolean newCheck;
                    boolean checksMatch;
                    HostedType checkedType = types.get(j);
                    boolean legacyCheck = TypeCheckValidator.legacyCheckAssignable(superType, checkedType);
                    boolean bl = checksMatch = legacyCheck == (newCheck = TypeCheckValidator.newCheckAssignable(superType, checkedType));
                    if (checksMatch) continue;
                    StringBuilder message = new StringBuilder();
                    message.append("\n********Type checks do not match:********\n");
                    message.append(String.format("super type: %s\n", superType.toString()));
                    message.append(String.format("checked type: %s\n", checkedType.toString()));
                    message.append(String.format("legacy check: %b\n", legacyCheck));
                    message.append(String.format("new check: %b\n", newCheck));
                    VMError.shouldNotReachHere(message.toString());
                }
            }
            return true;
        }

        static boolean legacyCheckAssignable(HostedType superType, HostedType checkedType) {
            int[] matches = superType.getAssignableFromMatches();
            int checkedID = checkedType.getTypeID();
            for (int i = 0; i < matches.length; i += 2) {
                int assignableStart = matches[i];
                int assignableEnd = assignableStart + matches[i + 1] - 1;
                if (checkedID < assignableStart || checkedID > assignableEnd) continue;
                return true;
            }
            return false;
        }

        static boolean newCheckAssignable(HostedType superType, HostedType checkedType) {
            int typeCheckStart = Short.toUnsignedInt(superType.getTypeCheckStart());
            int typeCheckRange = Short.toUnsignedInt(superType.getTypeCheckRange());
            int typeCheckSlot = Short.toUnsignedInt(superType.getTypeCheckSlot());
            int checkedTypeID = Short.toUnsignedInt(checkedType.getTypeCheckSlots()[typeCheckSlot]);
            return UnsignedMath.belowThan((int)(checkedTypeID - typeCheckStart), (int)typeCheckRange);
        }
    }

    private static final class InterfaceIDBuilder {
        final List<HostedType> heightOrderedTypes;
        final Map<HostedType, List<HostedType>> subtypeMap;
        final int startingSlotNum;
        final Map<HostedType, int[]> interfaceSlotIDMap = new HashMap<HostedType, int[]>();
        int numInterfaceSlots = -1;

        InterfaceIDBuilder(int startingSlotNum, List<HostedType> heightOrderedTypes, Map<HostedType, List<HostedType>> subtypeMap) {
            this.startingSlotNum = startingSlotNum;
            this.heightOrderedTypes = heightOrderedTypes;
            this.subtypeMap = subtypeMap;
        }

        void computeSlots() {
            Graph interfaceGraph = Graph.buildInterfaceGraph(this.heightOrderedTypes, this.subtypeMap);
            interfaceGraph.mergeDuplicates();
            interfaceGraph.generateDescendantIndex();
            this.calculateInterfaceIDs(interfaceGraph);
        }

        void calculateInterfaceIDs(Graph graph) {
            assert (graph.interfaceNodes != null);
            ArrayList<InterfaceSlot> slots = new ArrayList<InterfaceSlot>();
            slots.add(new InterfaceSlot(slots.size()));
            for (Node node : graph.interfaceNodes) {
                boolean foundAssignment = false;
                boolean redoSort = false;
                for (InterfaceSlot interfaceSlot : slots) {
                    Object result = interfaceSlot.tryAddGrouping(node);
                    if (result == InterfaceSlot.AddGroupingResult.SUCCESS) {
                        foundAssignment = true;
                        node.type.setTypeCheckSlot(TypeCheckBuilder.getShortValue(interfaceSlot.id + this.startingSlotNum));
                        break;
                    }
                    if (result != InterfaceSlot.AddGroupingResult.CAPACITY_OVERFLOW) continue;
                    redoSort = true;
                }
                if (!foundAssignment) {
                    InterfaceSlot newSlot = new InterfaceSlot(slots.size());
                    InterfaceSlot.AddGroupingResult addGroupingResult = newSlot.tryAddGrouping(node);
                    assert (addGroupingResult == InterfaceSlot.AddGroupingResult.SUCCESS) : "must be able to add first node";
                    node.type.setTypeCheckSlot(TypeCheckBuilder.getShortValue(newSlot.id + this.startingSlotNum));
                    slots.add(newSlot);
                }
                if (!redoSort) continue;
                slots.sort(Comparator.comparingInt(slot -> slot.numReservedIDs));
            }
            int numSlots = slots.size();
            assert (this.numInterfaceSlots == -1);
            this.numInterfaceSlots = numSlots;
            for (Node node : graph.nodes) {
                assert (!this.interfaceSlotIDMap.containsKey(node.type));
                this.interfaceSlotIDMap.put(node.type, new int[numSlots]);
            }
            for (InterfaceSlot slot3 : slots) {
                List<Set<Integer>> c1POrder = slot3.getC1POrder();
                int slotId = slot3.id;
                int id = 1;
                for (Set set : c1POrder) {
                    for (Integer nodeID : set) {
                        HostedType type = graph.nodes[nodeID.intValue()].type;
                        this.interfaceSlotIDMap.get((Object)type)[slotId] = id;
                    }
                    ++id;
                }
            }
            for (Node interfaceNode : graph.interfaceNodes) {
                int minId = Integer.MAX_VALUE;
                int maxId = Integer.MIN_VALUE;
                HostedType hostedType = interfaceNode.type;
                int slotId = Short.toUnsignedInt(hostedType.getTypeCheckSlot()) - this.startingSlotNum;
                HashSet<Integer> idCheck = new HashSet<Integer>();
                for (Node descendant : interfaceNode.sortedDescendants) {
                    int id = this.interfaceSlotIDMap.get(descendant.type)[slotId];
                    assert (id != 0);
                    minId = Integer.min(minId, id);
                    maxId = Integer.max(maxId, id);
                    idCheck.add(id);
                }
                hostedType.setTypeCheckRange(TypeCheckBuilder.getShortValue(minId), TypeCheckBuilder.getShortValue(maxId - minId + 1));
            }
            for (Node node : graph.nodes) {
                if (node.duplicates == null) continue;
                for (HostedType duplicate : node.duplicates) {
                    assert (!this.interfaceSlotIDMap.containsKey(duplicate));
                    this.interfaceSlotIDMap.put(duplicate, this.interfaceSlotIDMap.get(node.type));
                }
            }
        }

        private static class PrimeMatrix {
            final ContiguousGroup initialGroup;
            List<ContiguousGroup> containedGroups;
            Map<ContiguousGroup, Set<ContiguousGroup>> edgeMap;
            List<Set<Integer>> c1POrdering;
            Set<Integer> containedNodes;

            PrimeMatrix(ContiguousGroup initialGroup) {
                this.initialGroup = initialGroup;
                this.containedGroups = new ArrayList<ContiguousGroup>();
                this.containedGroups.add(initialGroup);
                this.edgeMap = new HashMap<ContiguousGroup, Set<ContiguousGroup>>();
            }

            void initializeC1PInformation() {
                this.containedNodes = new HashSet<Integer>();
                this.c1POrdering = new ArrayList<Set<Integer>>();
            }

            void copyC1PInformation(PrimeMatrix src) {
                this.containedNodes = new HashSet<Integer>(src.containedNodes);
                this.c1POrdering = new ArrayList<Set<Integer>>();
                for (Set<Integer> entry : src.c1POrdering) {
                    this.c1POrdering.add(new HashSet<Integer>(entry));
                }
            }

            boolean incorporateMatrices(Set<PrimeMatrix> matrices, List<ContiguousGroup> edges) {
                assert (this.containedGroups.size() == 1) : "Matrices can only be combined once";
                PrimeMatrix largestMatrix = null;
                int largestMatrixSize = Integer.MIN_VALUE;
                for (PrimeMatrix matrix : matrices) {
                    int matrixSize = matrix.containedGroups.size();
                    assert (matrixSize > 0);
                    if (matrixSize <= largestMatrixSize) continue;
                    largestMatrixSize = matrixSize;
                    largestMatrix = matrix;
                }
                if (largestMatrix != null) {
                    this.copyC1PInformation(largestMatrix);
                } else {
                    this.initializeC1PInformation();
                }
                PrimeMatrix finalLargestMatrix = largestMatrix;
                List<ContiguousGroup> spanningTree = this.computeSpanningTree(edges, largestMatrix);
                int expectedNumNodes = 1 + matrices.stream().filter(n -> n != finalLargestMatrix).mapToInt(n -> n.containedGroups.size()).sum();
                assert (spanningTree.size() == expectedNumNodes);
                for (ContiguousGroup grouping : spanningTree) {
                    if (this.addGroupAndCheckC1P(grouping)) continue;
                    return false;
                }
                for (PrimeMatrix matrix : matrices) {
                    List<ContiguousGroup> otherGroup = matrix.containedGroups;
                    assert (otherGroup.stream().noneMatch(this.containedGroups::contains)) : "the intersection between all prime matrices should be null";
                    this.containedGroups.addAll(otherGroup);
                    Map<ContiguousGroup, Set<ContiguousGroup>> otherEdgeMap = matrix.edgeMap;
                    for (Map.Entry<ContiguousGroup, Set<ContiguousGroup>> entry : otherEdgeMap.entrySet()) {
                        ContiguousGroup key = entry.getKey();
                        this.edgeMap.computeIfAbsent(key, k -> new HashSet()).addAll((Collection)entry.getValue());
                    }
                }
                this.edgeMap.put(this.initialGroup, new HashSet());
                for (ContiguousGroup edge : edges) {
                    this.edgeMap.get(this.initialGroup).add(edge);
                    this.edgeMap.computeIfAbsent(edge, k -> new HashSet()).add(this.initialGroup);
                }
                return true;
            }

            List<ContiguousGroup> computeSpanningTree(List<ContiguousGroup> edges, PrimeMatrix largestMatrix) {
                ArrayList<ContiguousGroup> list = new ArrayList<ContiguousGroup>();
                list.add(this.initialGroup);
                HashSet<PrimeMatrix> coveredMatrices = new HashSet<PrimeMatrix>();
                if (largestMatrix != null) {
                    coveredMatrices.add(largestMatrix);
                }
                for (ContiguousGroup edge : edges) {
                    PrimeMatrix matrix = edge.primeMatrix;
                    if (coveredMatrices.contains(matrix)) continue;
                    coveredMatrices.add(matrix);
                    list.addAll(matrix.getSpanningTree(edge));
                }
                return list;
            }

            List<ContiguousGroup> getSpanningTree(ContiguousGroup startingNode) {
                HashSet<ContiguousGroup> seenNodes = new HashSet<ContiguousGroup>();
                ArrayList<ContiguousGroup> list = new ArrayList<ContiguousGroup>();
                this.getSpanningTreeHelper(startingNode, list, seenNodes);
                return list;
            }

            void getSpanningTreeHelper(ContiguousGroup node, List<ContiguousGroup> list, Set<ContiguousGroup> seenNodes) {
                list.add(node);
                seenNodes.add(node);
                Set<ContiguousGroup> edges = this.edgeMap.get(node);
                if (edges != null) {
                    for (ContiguousGroup edge : edges) {
                        if (seenNodes.contains(edge)) continue;
                        this.getSpanningTreeHelper(edge, list, seenNodes);
                    }
                }
            }

            boolean addGroupAndCheckC1P(ContiguousGroup grouping) {
                Set<Integer> newGroup = Arrays.stream(grouping.sortedGroupIds).boxed().collect(Collectors.toSet());
                Set uncoveredNodes = newGroup.stream().filter(n -> !this.containedNodes.contains(n)).collect(Collectors.toSet());
                int numSets = this.c1POrdering.size();
                if (numSets == 0) {
                    this.c1POrdering.add(uncoveredNodes);
                } else if (numSets == 1) {
                    this.c1POrdering.get(0).removeAll(newGroup);
                    this.c1POrdering.add(newGroup.stream().filter(this.containedNodes::contains).collect(Collectors.toSet()));
                    this.c1POrdering.add(uncoveredNodes);
                } else {
                    int i;
                    SetColor[] setColors = new SetColor[this.c1POrdering.size()];
                    int leftIntersect = Integer.MIN_VALUE;
                    int rightIntersect = Integer.MIN_VALUE;
                    for (i = 0; i < this.c1POrdering.size(); ++i) {
                        SetColor color;
                        setColors[i] = color = SetColor.getSetColor(this.c1POrdering.get(i), newGroup);
                        if (color == SetColor.EMPTY) continue;
                        if (leftIntersect == Integer.MIN_VALUE) {
                            leftIntersect = i;
                        }
                        rightIntersect = i;
                    }
                    assert (leftIntersect != Integer.MIN_VALUE && rightIntersect != Integer.MIN_VALUE);
                    for (i = leftIntersect + 1; i < rightIntersect; ++i) {
                        if (setColors[i] == SetColor.FULL) continue;
                        return false;
                    }
                    SetColor rightColor = setColors[rightIntersect];
                    SetColor leftColor = setColors[leftIntersect];
                    if (uncoveredNodes.size() == 0) {
                        this.splitColoredNodes(rightColor, newGroup, rightIntersect, rightIntersect);
                        if (leftIntersect != rightIntersect) {
                            this.splitColoredNodes(leftColor, newGroup, leftIntersect, leftIntersect + 1);
                        }
                    } else if (leftIntersect == 0 && leftColor == SetColor.FULL) {
                        this.splitColoredNodes(rightColor, newGroup, rightIntersect, rightIntersect);
                        this.c1POrdering.add(0, uncoveredNodes);
                    } else if (rightIntersect == numSets - 1 && rightColor == SetColor.FULL) {
                        this.splitColoredNodes(leftColor, newGroup, leftIntersect, leftIntersect + 1);
                        this.c1POrdering.add(uncoveredNodes);
                    } else {
                        return false;
                    }
                }
                this.containedNodes.addAll(uncoveredNodes);
                return true;
            }

            void splitColoredNodes(SetColor color, Set<Integer> coloredSet, int srcIndex, int dstIndex) {
                assert (color != SetColor.EMPTY);
                if (color != SetColor.FULL) {
                    Set newSet = SetColor.splitOffColored(this.c1POrdering.get(srcIndex), coloredSet);
                    this.c1POrdering.add(dstIndex, newSet);
                }
            }

            static final class SetColor
            extends Enum<SetColor> {
                public static final /* enum */ SetColor EMPTY = new SetColor();
                public static final /* enum */ SetColor PARTIAL = new SetColor();
                public static final /* enum */ SetColor FULL = new SetColor();
                private static final /* synthetic */ SetColor[] $VALUES;

                public static SetColor[] values() {
                    return (SetColor[])$VALUES.clone();
                }

                public static SetColor valueOf(String name) {
                    return Enum.valueOf(SetColor.class, name);
                }

                private static SetColor getSetColor(Set<Integer> set, Set<Integer> coloredSet) {
                    long numColoredNodes = set.stream().filter(coloredSet::contains).count();
                    if (numColoredNodes == 0L) {
                        return EMPTY;
                    }
                    if (numColoredNodes == (long)set.size()) {
                        return FULL;
                    }
                    return PARTIAL;
                }

                private static Set<Integer> splitOffColored(Set<Integer> set, Set<Integer> coloredSet) {
                    Set<Integer> coloredNodes = set.stream().filter(coloredSet::contains).collect(Collectors.toSet());
                    assert (coloredNodes.size() != 0 && coloredNodes.size() < set.size());
                    set.removeAll(coloredNodes);
                    return coloredNodes;
                }

                static {
                    $VALUES = new SetColor[]{EMPTY, PARTIAL, FULL};
                }
            }
        }

        private static final class InterfaceSlot {
            final int id;
            int currentTimeStamp;
            int numReservedIDs;
            Set<PrimeMatrix> matrices = new HashSet<PrimeMatrix>();
            Map<Integer, Set<ContiguousGroup>> columnToGroupingMap = new HashMap<Integer, Set<ContiguousGroup>>();

            InterfaceSlot(int id) {
                this.id = id;
                this.currentTimeStamp = 0;
                this.numReservedIDs = 1;
            }

            AddGroupingResult tryAddGrouping(Node interfaceNode) {
                PrimeMatrix newPrimeMatrix;
                int[] sortedGroupIds = Arrays.stream(interfaceNode.sortedDescendants).mapToInt(n -> n.id).toArray();
                ContiguousGroup newGrouping = new ContiguousGroup(sortedGroupIds);
                int timestamp = ++this.currentTimeStamp;
                ArrayList<ContiguousGroup> edges = new ArrayList<ContiguousGroup>();
                HashSet<PrimeMatrix> linkedPrimeMatrices = new HashSet<PrimeMatrix>();
                for (int column : sortedGroupIds) {
                    Set<ContiguousGroup> groupings = this.columnToGroupingMap.get(column);
                    if (groupings == null) continue;
                    for (ContiguousGroup existingGrouping : groupings) {
                        if (existingGrouping.lastTimeStamp == timestamp) continue;
                        existingGrouping.lastTimeStamp = timestamp;
                        boolean strictlyOverlap = InterfaceSlot.strictlyOverlaps(newGrouping, existingGrouping);
                        if (!strictlyOverlap) continue;
                        edges.add(existingGrouping);
                        linkedPrimeMatrices.add(existingGrouping.primeMatrix);
                    }
                }
                newGrouping.primeMatrix = newPrimeMatrix = new PrimeMatrix(newGrouping);
                boolean satisfiesC1P = newPrimeMatrix.incorporateMatrices(linkedPrimeMatrices, edges);
                if (!satisfiesC1P) {
                    return AddGroupingResult.INVALID_C1P;
                }
                int numIDsDelta = newPrimeMatrix.c1POrdering.size() - linkedPrimeMatrices.stream().mapToInt(n -> n.c1POrdering.size()).sum();
                assert (numIDsDelta >= 0);
                int newNumReservedIDs = this.numReservedIDs + numIDsDelta;
                if (newNumReservedIDs > 65536) {
                    return AddGroupingResult.CAPACITY_OVERFLOW;
                }
                this.numReservedIDs = newNumReservedIDs;
                this.matrices.add(newPrimeMatrix);
                for (PrimeMatrix removedMatrix : linkedPrimeMatrices) {
                    this.matrices.remove(removedMatrix);
                    for (ContiguousGroup grouping : removedMatrix.containedGroups) {
                        grouping.primeMatrix = newPrimeMatrix;
                    }
                }
                for (Object connection : (Object)sortedGroupIds) {
                    this.columnToGroupingMap.computeIfAbsent((int)connection, k -> new HashSet()).add(newGrouping);
                }
                return AddGroupingResult.SUCCESS;
            }

            static boolean strictlyOverlaps(ContiguousGroup a, ContiguousGroup b) {
                int[] aArray = a.sortedGroupIds;
                int[] bArray = b.sortedGroupIds;
                int aLength = aArray.length;
                int bLength = bArray.length;
                int aIdx = 0;
                int bIdx = 0;
                int numMatches = 0;
                while (aIdx < aLength && bIdx < bLength) {
                    int aValue = aArray[aIdx];
                    int bValue = bArray[bIdx];
                    if (aValue == bValue) {
                        ++numMatches;
                        ++aIdx;
                        ++bIdx;
                        continue;
                    }
                    if (aValue < bValue) {
                        ++aIdx;
                        continue;
                    }
                    ++bIdx;
                }
                int minLength = Math.min(aLength, bLength);
                assert (numMatches != 0 && numMatches <= minLength);
                assert (aLength != bLength || numMatches != aLength);
                return numMatches != minLength;
            }

            List<Set<Integer>> getC1POrder() {
                List sizeOrderedMatrices = this.matrices.stream().sorted(Comparator.comparingInt(n -> -n.containedNodes.size())).collect(Collectors.toList());
                ArrayList<Set<Integer>> c1POrdering = new ArrayList<Set<Integer>>();
                HashSet<Integer> coveredNodes = new HashSet<Integer>();
                block0: for (PrimeMatrix matrix : sizeOrderedMatrices) {
                    List<Set<Integer>> newOrderingConstraints = matrix.c1POrdering;
                    assert (matrix.containedNodes.size() > 0);
                    Integer matrixRepresentativeNode = (Integer)matrix.containedNodes.stream().findAny().get();
                    boolean hasOverlap = coveredNodes.contains(matrixRepresentativeNode);
                    if (!hasOverlap) {
                        c1POrdering.addAll(newOrderingConstraints);
                        coveredNodes.addAll(matrix.containedNodes);
                        continue;
                    }
                    assert (coveredNodes.containsAll(matrix.containedNodes));
                    assert (InterfaceSlot.verifyC1POrderingProperty(c1POrdering, matrix));
                    for (int i = 0; i < c1POrdering.size(); ++i) {
                        Set item = (Set)c1POrdering.get(i);
                        hasOverlap = item.contains(matrixRepresentativeNode);
                        if (!hasOverlap) continue;
                        item.removeAll(matrix.containedNodes);
                        c1POrdering.addAll(i + 1, newOrderingConstraints);
                        if (item.size() != 0) continue block0;
                        c1POrdering.remove(i);
                        continue block0;
                    }
                }
                return c1POrdering;
            }

            static boolean verifyC1POrderingProperty(List<Set<Integer>> c1POrdering, PrimeMatrix matrix) {
                ArrayList<Integer> overlappingSets = new ArrayList<Integer>();
                for (int i = 0; i < c1POrdering.size(); ++i) {
                    Set<Integer> item = c1POrdering.get(i);
                    boolean hasOverlap = item.stream().anyMatch(n -> matrix.containedNodes.contains(n));
                    if (!hasOverlap) continue;
                    overlappingSets.add(i);
                }
                return overlappingSets.size() == 1;
            }

            static enum AddGroupingResult {
                CAPACITY_OVERFLOW,
                INVALID_C1P,
                SUCCESS;

            }
        }

        private static final class ContiguousGroup {
            final int[] sortedGroupIds;
            PrimeMatrix primeMatrix;
            int lastTimeStamp = -1;

            ContiguousGroup(int[] sortedGroupIds) {
                this.sortedGroupIds = sortedGroupIds;
            }
        }

        private static class Graph {
            Node[] nodes;
            Node[] interfaceNodes;

            Graph(Node[] nodes) {
                this.nodes = nodes;
            }

            void mergeDuplicates() {
                HashMap<Integer, ArrayList> interfaceHashMap = new HashMap<Integer, ArrayList>();
                HashMap classHashMap = new HashMap();
                HashMap<Node, Set<HostedType>> duplicateMap = new HashMap<Node, Set<HostedType>>();
                for (Node node : this.nodes) {
                    Node[] ancestors = node.sortedAncestors;
                    int length = ancestors.length;
                    assert (length != 0);
                    boolean isNodeInterface = node.isInterface;
                    if (length == 1) {
                        if (isNodeInterface) continue;
                        Node ancestor = ancestors[0];
                        Graph.recordDuplicateRelation(duplicateMap, ancestor, node);
                        this.nodes[node.id] = null;
                        continue;
                    }
                    int hash = Graph.getDuplicateHash(ancestors);
                    HashMap<Integer, ArrayList> destinationMap = isNodeInterface ? interfaceHashMap : classHashMap;
                    destinationMap.computeIfAbsent(hash, k -> new ArrayList()).add(node);
                }
                for (Map.Entry entry : interfaceHashMap.entrySet()) {
                    ArrayList interfaces = (ArrayList)entry.getValue();
                    ArrayList classes = (ArrayList)classHashMap.get(entry.getKey());
                    if (classes == null) continue;
                    for (Node interfaceNode : interfaces) {
                        for (int i = 0; i < classes.size(); ++i) {
                            Node classNode = (Node)classes.get(i);
                            if (classNode == null || !this.tryMergeNodes(duplicateMap, interfaceNode, classNode)) continue;
                            classes.set(i, null);
                        }
                    }
                }
                for (Map.Entry entry : classHashMap.entrySet()) {
                    ArrayList classes = (ArrayList)entry.getValue();
                    int numClasses = classes.size();
                    for (int i = 0; i < numClasses - 1; ++i) {
                        Node classNode = (Node)classes.get(i);
                        if (classNode == null) continue;
                        for (int j = i + 1; j < numClasses; ++j) {
                            Node duplicateCandidate = (Node)classes.get(j);
                            if (duplicateCandidate == null || !this.tryMergeNodes(duplicateMap, classNode, duplicateCandidate)) continue;
                            classes.set(j, null);
                        }
                    }
                }
                for (Map.Entry entry : duplicateMap.entrySet()) {
                    ((Node)entry.getKey()).duplicates = (Set)entry.getValue();
                }
                ArrayList<Node> compactedNodeArray = new ArrayList<Node>();
                for (Node node : this.nodes) {
                    if (node == null) continue;
                    node.id = compactedNodeArray.size();
                    compactedNodeArray.add(node);
                }
                this.nodes = compactedNodeArray.toArray(new Node[0]);
            }

            static int getDuplicateHash(Node[] ancestors) {
                int length = ancestors.length;
                return (length << 16) + Arrays.stream(ancestors).mapToInt(n -> n.id * n.id).sum();
            }

            boolean tryMergeNodes(Map<Node, Set<HostedType>> duplicateMap, Node node, Node duplicateCandidate) {
                if (Graph.areDuplicates(node, duplicateCandidate)) {
                    Graph.recordDuplicateRelation(duplicateMap, node, duplicateCandidate);
                    int duplicateIdx = duplicateCandidate.id;
                    assert (!this.nodes[duplicateIdx].isInterface);
                    this.nodes[duplicateIdx] = null;
                    return true;
                }
                return false;
            }

            static boolean areDuplicates(Node a, Node b) {
                Node[] aAncestors = a.sortedAncestors;
                Node[] bAncestors = b.sortedAncestors;
                if (aAncestors.length != bAncestors.length) {
                    return false;
                }
                for (int i = 0; i < aAncestors.length; ++i) {
                    if (aAncestors[i] == bAncestors[i]) continue;
                    return false;
                }
                return true;
            }

            static void recordDuplicateRelation(Map<Node, Set<HostedType>> duplicateMap, Node node, Node duplicate) {
                assert (!duplicateMap.containsKey(duplicate)) : "By removing this node, I am losing record of some duplicates.";
                duplicateMap.computeIfAbsent(node, k -> new HashSet()).add(duplicate.type);
            }

            void generateDescendantIndex() {
                HashMap<Node, Set> descendantMap = new HashMap<Node, Set>();
                Node[] emptyDescendant = new Node[]{};
                ArrayList<Node> interfaceList = new ArrayList<Node>();
                for (int i = this.nodes.length - 1; i >= 0; --i) {
                    Node node = this.nodes[i];
                    if (node.isInterface) {
                        Set descendants = descendantMap.computeIfAbsent(node, k -> new HashSet());
                        descendants.add(node);
                        Node[] descendantArray = descendants.toArray(new Node[0]);
                        Arrays.sort(descendantArray, Comparator.comparingInt(n -> n.id));
                        node.sortedDescendants = descendantArray;
                        interfaceList.add(node);
                    } else {
                        node.sortedDescendants = emptyDescendant;
                    }
                    for (Node ancestor : node.sortedAncestors) {
                        descendantMap.computeIfAbsent(ancestor, k -> new HashSet()).add(node);
                    }
                }
                this.interfaceNodes = interfaceList.toArray(new Node[0]);
                int maxDescendants = Integer.MIN_VALUE;
                int maxAncestors = Integer.MIN_VALUE;
                for (Node node : interfaceList) {
                    maxDescendants = Math.max(node.sortedDescendants.length, maxDescendants);
                    maxAncestors = Math.max(node.sortedAncestors.length, maxAncestors);
                }
                maxDescendants = Integer.MIN_VALUE;
                maxAncestors = Integer.MIN_VALUE;
                for (Node node : this.nodes) {
                    maxDescendants = Math.max(node.sortedDescendants.length, maxDescendants);
                    maxAncestors = Math.max(node.sortedAncestors.length, maxAncestors);
                }
            }

            static Graph buildInterfaceGraph(List<HostedType> heightOrderedTypes, Map<HostedType, List<HostedType>> subtypeMap) {
                HashMap<HostedType, Set> interfaceAncestors = new HashMap<HostedType, Set>();
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (HostedType type : heightOrderedTypes) {
                    boolean isTypeInterface;
                    Set ancestors = interfaceAncestors.computeIfAbsent(type, arg_0 -> Graph.lambda$buildInterfaceGraph$6(isTypeInterface = TypeCheckBuilder.isInterface(type), arg_0));
                    if (ancestors == null) continue;
                    int id = nodes.size();
                    Node newNode = new Node(id, type, isTypeInterface);
                    nodes.add(newNode);
                    if (isTypeInterface) {
                        ancestors.add(newNode);
                    }
                    Node[] sortedAncestors = ancestors.toArray(new Node[0]);
                    Arrays.sort(sortedAncestors, Comparator.comparingInt(n -> n.id));
                    newNode.sortedAncestors = sortedAncestors;
                    for (HostedType child : subtypeMap.get(type)) {
                        interfaceAncestors.computeIfAbsent(child, k -> new HashSet()).addAll(ancestors);
                    }
                }
                Node[] nodeArray = nodes.toArray(new Node[0]);
                int maxAncestors = -1;
                for (Node node : nodeArray) {
                    maxAncestors = Math.max(maxAncestors, node.sortedAncestors.length);
                }
                return new Graph(nodeArray);
            }

            private static /* synthetic */ Set lambda$buildInterfaceGraph$6(boolean isTypeInterface, HostedType k) {
                return isTypeInterface ? new HashSet() : null;
            }
        }

        private static final class Node {
            Node[] sortedAncestors;
            Node[] sortedDescendants;
            int id;
            final HostedType type;
            final boolean isInterface;
            Set<HostedType> duplicates;

            Node(int id, HostedType type, boolean isInterface) {
                this.id = id;
                this.type = type;
                this.isInterface = isInterface;
            }
        }
    }

    private static final class ClassIDBuilder {
        final HostedType objectType;
        final List<HostedType> allIncludedRoots;
        final List<HostedType> heightOrderedTypes;
        final Map<HostedType, List<HostedType>> subtypeMap;
        final Map<HostedType, int[]> classSlotIDMap = new HashMap<HostedType, int[]>();
        int numClassSlots = -1;

        ClassIDBuilder(HostedType objectType, List<HostedType> allIncludedRoots, List<HostedType> heightOrderedTypes, Map<HostedType, List<HostedType>> subtypeMap) {
            this.objectType = objectType;
            this.heightOrderedTypes = heightOrderedTypes;
            this.allIncludedRoots = allIncludedRoots;
            this.subtypeMap = subtypeMap;
        }

        void computeSlots() {
            Map<HostedType, Integer> numClassDescendantsMap = this.computeNumClassDescendants();
            this.calculateIDs(numClassDescendantsMap);
        }

        Map<HostedType, Integer> computeNumClassDescendants() {
            HashMap<HostedType, Integer> numClassDescendantsMap = new HashMap<HostedType, Integer>();
            for (int i = this.heightOrderedTypes.size() - 1; i >= 0; --i) {
                HostedType type = this.heightOrderedTypes.get(i);
                if (TypeCheckBuilder.isInterface(type)) continue;
                int numDescendants = 0;
                for (HostedType child : this.subtypeMap.get(type)) {
                    if (TypeCheckBuilder.isInterface(child)) continue;
                    numDescendants += 1 + (Integer)numClassDescendantsMap.get(child);
                }
                numClassDescendantsMap.put(type, numDescendants);
            }
            return numClassDescendantsMap;
        }

        void calculateIDs(Map<HostedType, Integer> numClassDescendantsMap) {
            ArrayList<Integer> currentIDs = new ArrayList<Integer>();
            ArrayList<Integer> numReservedIDs = new ArrayList<Integer>();
            currentIDs.add(0);
            numReservedIDs.add(0);
            for (HostedType root : this.allIncludedRoots) {
                this.assignID(root, numClassDescendantsMap, currentIDs, numReservedIDs);
            }
            assert (this.numClassSlots == -1);
            this.numClassSlots = currentIDs.size();
            for (HostedType type : this.heightOrderedTypes) {
                if (!TypeCheckBuilder.isInterface(type)) continue;
                int dim = type.getArrayDimension();
                assert (!this.classSlotIDMap.containsKey(type));
                this.classSlotIDMap.put(type, this.classSlotIDMap.get(this.objectType.getArrayClass(dim)));
            }
        }

        void assignID(HostedType type, Map<HostedType, Integer> numClassDescendantsMap, ArrayList<Integer> currentIDs, ArrayList<Integer> numReservedIDs) {
            assert (TypeCheckBuilder.shouldIncludeType(type) && !TypeCheckBuilder.isInterface(type));
            int numClassDescendants = numClassDescendantsMap.get(type);
            TypeState state = ClassIDBuilder.generateTypeState(numClassDescendants, currentIDs, numReservedIDs);
            int reservedID = state.reservedID;
            int slotNum = state.slotNum;
            int assignedID = state.assignedID;
            int maxSubtypeID = state.maxSubtypeID;
            assert (!this.classSlotIDMap.containsKey(type));
            this.classSlotIDMap.put(type, currentIDs.stream().mapToInt(n -> n).toArray());
            for (HostedType subtype : this.subtypeMap.get(type)) {
                if (TypeCheckBuilder.isInterface(subtype)) continue;
                this.assignID(subtype, numClassDescendantsMap, currentIDs, numReservedIDs);
                assert (currentIDs.get(slotNum) >= assignedID);
            }
            assert (currentIDs.get(slotNum) == maxSubtypeID);
            type.setTypeCheckSlot(TypeCheckBuilder.getShortValue(slotNum));
            type.setTypeCheckRange(TypeCheckBuilder.getShortValue(assignedID), TypeCheckBuilder.getShortValue(maxSubtypeID - assignedID + 1));
            if (reservedID != 0) {
                assert (numReservedIDs.get(slotNum) == reservedID);
                int newNumReservedIDs = reservedID - 1;
                numReservedIDs.set(slotNum, newNumReservedIDs);
                currentIDs.set(slotNum, newNumReservedIDs == 0 ? 0 : 65536 - newNumReservedIDs);
            }
        }

        static TypeState generateTypeState(int numClassDescendants, ArrayList<Integer> currentIDs, ArrayList<Integer> numReservedIDs) {
            int maxSubtypeID;
            int reservedID = 0;
            int slotNum = currentIDs.size() - 1;
            int assignedID = currentIDs.get(slotNum) + 1;
            int currentNumReservedIDs = numReservedIDs.get(slotNum);
            int currentCapacity = 65536 - currentNumReservedIDs;
            assert (assignedID <= currentCapacity);
            if (assignedID == currentCapacity) {
                currentIDs.set(slotNum, currentNumReservedIDs == 0 ? 0 : 65536 - currentNumReservedIDs);
                ++slotNum;
                currentIDs.add(0);
                currentNumReservedIDs = 0;
                currentCapacity = 65536;
                numReservedIDs.add(currentNumReservedIDs);
                assignedID = 1;
            }
            if ((maxSubtypeID = assignedID + numClassDescendants) >= currentCapacity) {
                if (assignedID + 1 == currentCapacity) {
                    currentIDs.set(slotNum, currentNumReservedIDs == 0 ? 0 : 65536 - currentNumReservedIDs);
                    ++slotNum;
                    currentIDs.add(0);
                    currentNumReservedIDs = 0;
                    currentCapacity = 65536;
                    numReservedIDs.add(currentNumReservedIDs);
                    assignedID = 1;
                    maxSubtypeID = assignedID + numClassDescendants;
                }
                if (maxSubtypeID >= currentCapacity) {
                    reservedID = ++currentNumReservedIDs;
                    maxSubtypeID = 65536 - reservedID;
                    numReservedIDs.set(slotNum, currentNumReservedIDs);
                }
            }
            currentIDs.set(slotNum, assignedID);
            return new TypeState(reservedID, slotNum, assignedID, maxSubtypeID);
        }

        private static final class TypeState {
            final int reservedID;
            final int slotNum;
            final int assignedID;
            final int maxSubtypeID;

            private TypeState(int reservedID, int slotNum, int assignedID, int maxSubtypeID) {
                this.reservedID = reservedID;
                this.slotNum = slotNum;
                this.assignedID = assignedID;
                this.maxSubtypeID = maxSubtypeID;
            }
        }
    }
}

