/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.windows.headers.ErrHandlingAPI;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class WindowsRegisterDumper
implements RegisterDumper {
    @Override
    public void dumpRegisters(Log log, RegisterDumper.Context context) {
        WindowsRegisterDumper.dumpRegisters(log, (ErrHandlingAPI.CONTEXT)context);
    }

    private static void dumpRegisters(Log log, ErrHandlingAPI.CONTEXT context) {
        RegisterDumper.dumpReg(log, "RAX ", context.Rax());
        RegisterDumper.dumpReg(log, "RBX ", context.Rbx());
        RegisterDumper.dumpReg(log, "RCX ", context.Rcx());
        RegisterDumper.dumpReg(log, "RDX ", context.Rdx());
        RegisterDumper.dumpReg(log, "RBP ", context.Rbp());
        RegisterDumper.dumpReg(log, "RSI ", context.Rsi());
        RegisterDumper.dumpReg(log, "RDI ", context.Rdi());
        RegisterDumper.dumpReg(log, "RSP ", context.Rsp());
        RegisterDumper.dumpReg(log, "R8  ", context.R8());
        RegisterDumper.dumpReg(log, "R9  ", context.R9());
        RegisterDumper.dumpReg(log, "R10 ", context.R10());
        RegisterDumper.dumpReg(log, "R11 ", context.R11());
        RegisterDumper.dumpReg(log, "R12 ", context.R12());
        RegisterDumper.dumpReg(log, "R13 ", context.R13());
        RegisterDumper.dumpReg(log, "R14 ", context.R14());
        RegisterDumper.dumpReg(log, "R15 ", context.R15());
        RegisterDumper.dumpReg(log, "EFL ", context.EFlags());
        RegisterDumper.dumpReg(log, "RIP ", context.Rip());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase getHeapBase(RegisterDumper.Context context) {
        return WordFactory.pointer((long)((ErrHandlingAPI.CONTEXT)context).R14());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase getThreadPointer(RegisterDumper.Context context) {
        return WordFactory.pointer((long)((ErrHandlingAPI.CONTEXT)context).R15());
    }

    @Override
    public PointerBase getSP(RegisterDumper.Context context) {
        return WordFactory.pointer((long)((ErrHandlingAPI.CONTEXT)context).Rsp());
    }

    @Override
    public PointerBase getIP(RegisterDumper.Context context) {
        return WordFactory.pointer((long)((ErrHandlingAPI.CONTEXT)context).Rip());
    }
}

