/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.thread.JavaThreads;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ThreadStatusRecomputation
implements RecomputeFieldValue.CustomFieldValueComputer {
    ThreadStatusRecomputation() {
    }

    @Override
    public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
        Thread thread = (Thread)receiver;
        if (thread.getState() == Thread.State.TERMINATED) {
            return 2;
        }
        assert (thread.getState() == Thread.State.NEW) : "All threads are in NEW state during image generation";
        if (thread == JavaThreads.singleton().mainThread) {
            return 5;
        }
        return 0;
    }
}

