/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.posix.PosixSystemPropertiesSupport;
import com.oracle.svm.core.posix.headers.Limits;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.darwin.Foundation;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@CLibrary(value="darwin", requireStatic=true)
public class DarwinSystemPropertiesSupport
extends PosixSystemPropertiesSupport {
    private static volatile String osVersionValue = null;

    @Override
    protected String tmpdirValue() {
        int buflen = Limits.PATH_MAX();
        CCharPointer tmpPath = (CCharPointer)StackValue.get((int)buflen);
        UnsignedWord pathSize = Unistd.confstr(Unistd._CS_DARWIN_USER_TEMP_DIR(), tmpPath, WordFactory.unsigned((int)buflen));
        if (pathSize.aboveThan(0) && pathSize.belowOrEqual(buflen)) {
            return CTypeConversion.toJavaString((CCharPointer)tmpPath);
        }
        return "/var/tmp";
    }

    @Override
    protected String osVersionValue() {
        if (osVersionValue != null) {
            return osVersionValue;
        }
        Foundation.NSOperatingSystemVersion osVersion = (Foundation.NSOperatingSystemVersion)StackValue.get(Foundation.NSOperatingSystemVersion.class);
        Foundation.operatingSystemVersion(osVersion);
        if (osVersion.isNull()) {
            osVersionValue = "Unknown";
            return "Unknown";
        }
        long major = osVersion.getMajorVersion();
        long minor = osVersion.getMinorVersion();
        long patch = osVersion.getPatchVersion();
        osVersionValue = major + "." + minor + "." + patch;
        return osVersionValue;
    }
}

