/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public abstract class ObjectHeader {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected ObjectHeader() {
    }

    public abstract int getReservedBitsMask();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public abstract long encodeAsImageHeapObjectHeader(ImageHeapObject var1, long var2);

    public abstract Word encodeAsTLABObjectHeader(DynamicHub var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract DynamicHub dynamicHubFromObjectHeader(UnsignedWord var1);

    public static DynamicHub readDynamicHubFromObject(Object o) {
        return KnownIntrinsics.readHub(o);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract DynamicHub readDynamicHubFromPointer(Pointer var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract void initializeHeaderOfNewObject(Pointer var1, DynamicHub var2, HeapKind var3, boolean var4);

    public static enum HeapKind {
        Unmanaged,
        ImageHeap;

    }
}

