/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class GCCause {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final ArrayList<GCCause> HostedGCCauseList = new ArrayList();
    public static final GCCause JavaLangSystemGC = new GCCause("java.lang.System.gc()", 0);
    public static final GCCause UnitTest = new GCCause("UnitTest", 1);
    public static final GCCause TestGCInDeoptimizer = new GCCause("TestGCInDeoptimizer", 2);
    protected static GCCause[] GCCauses = new GCCause[]{JavaLangSystemGC, UnitTest, TestGCInDeoptimizer};
    private final int id;
    private final String name;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected GCCause(String name, int id) {
        this.id = id;
        this.name = name;
        this.addGCCauseMapping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private void addGCCauseMapping() {
        ArrayList<GCCause> arrayList = HostedGCCauseList;
        synchronized (arrayList) {
            while (HostedGCCauseList.size() <= this.id) {
                HostedGCCauseList.add(null);
            }
            VMError.guarantee(HostedGCCauseList.get(this.id) == null, this.name + " and another GCCause have the same id.");
            HostedGCCauseList.set(this.id, this);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static GCCause fromId(int causeId) {
        return GCCauses[causeId];
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void cacheReverseMapping() {
        GCCauses = HostedGCCauseList.toArray(new GCCause[HostedGCCauseList.size()]);
    }
}

