/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64RegisterConfig;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

final class AMD64CalleeSavedRegisters
extends CalleeSavedRegisters {
    @Fold
    public static AMD64CalleeSavedRegisters singleton() {
        return (AMD64CalleeSavedRegisters)CalleeSavedRegisters.singleton();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void createAndRegister() {
        SubstrateTargetDescription target = ConfigurationValues.getTarget();
        SubstrateAMD64RegisterConfig registerConfig = new SubstrateAMD64RegisterConfig(SubstrateRegisterConfig.ConfigKind.NORMAL, null, target, SubstrateOptions.PreserveFramePointer.getValue());
        Register frameRegister = registerConfig.getFrameRegister();
        ArrayList<Register> calleeSavedRegisters = new ArrayList<Register>(registerConfig.getAllocatableRegisters().asList());
        Collections.reverse(calleeSavedRegisters);
        int offset = 0;
        HashMap<Register, Integer> calleeSavedRegisterOffsets = new HashMap<Register, Integer>();
        for (Register register : calleeSavedRegisters) {
            calleeSavedRegisterOffsets.put(register, offset);
            offset += target.arch.getLargestStorableKind(register.getRegisterCategory()).getSizeInBytes();
        }
        int calleeSavedRegistersSizeInBytes = offset;
        int saveAreaOffsetInFrame = -(FrameAccess.returnAddressSize() + (SubstrateOptions.PreserveFramePointer.getValue() != false ? FrameAccess.wordSize() : 0) + calleeSavedRegistersSizeInBytes);
        ImageSingletons.add(CalleeSavedRegisters.class, (Object)new AMD64CalleeSavedRegisters(frameRegister, calleeSavedRegisters, calleeSavedRegisterOffsets, calleeSavedRegistersSizeInBytes, saveAreaOffsetInFrame));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private AMD64CalleeSavedRegisters(Register frameRegister, List<Register> calleeSavedRegisters, Map<Register, Integer> offsetsInSaveArea, int saveAreaSize, int saveAreaOffsetInFrame) {
        super(frameRegister, calleeSavedRegisters, offsetsInSaveArea, saveAreaSize, saveAreaOffsetInFrame);
    }

    public void emitSave(AMD64MacroAssembler asm, int frameSize) {
        SubstrateTargetDescription target = ConfigurationValues.getTarget();
        AMD64 arch = (AMD64)target.arch;
        boolean hasAVX = arch.getFeatures().contains(AMD64.CPUFeature.AVX);
        boolean hasAVX512 = arch.getFeatures().contains(AMD64.CPUFeature.AVX512F);
        for (Register register : this.calleeSavedRegisters) {
            AMD64Address address = this.calleeSaveAddress(asm, frameSize, register);
            Register.RegisterCategory category = register.getRegisterCategory();
            if (category.equals((Object)AMD64.CPU)) {
                asm.movq(address, register);
                continue;
            }
            if (category.equals((Object)AMD64.XMM)) {
                if (hasAVX512) {
                    asm.evmovdqu64(address, register);
                    continue;
                }
                if (hasAVX) {
                    asm.vmovdqu(address, register);
                    continue;
                }
                asm.movdqu(address, register);
                continue;
            }
            if (category.equals((Object)AMD64.MASK)) {
                throw VMError.unimplemented();
            }
            throw VMError.shouldNotReachHere();
        }
    }

    public void emitRestore(AMD64MacroAssembler asm, int frameSize, Register excludedRegister) {
        SubstrateTargetDescription target = ConfigurationValues.getTarget();
        AMD64 arch = (AMD64)target.arch;
        boolean hasAVX = arch.getFeatures().contains(AMD64.CPUFeature.AVX);
        boolean hasAVX512 = arch.getFeatures().contains(AMD64.CPUFeature.AVX512F);
        for (Register register : this.calleeSavedRegisters) {
            if (register.equals((Object)excludedRegister)) continue;
            AMD64Address address = this.calleeSaveAddress(asm, frameSize, register);
            Register.RegisterCategory category = register.getRegisterCategory();
            if (category.equals((Object)AMD64.CPU)) {
                asm.movq(register, address);
                continue;
            }
            if (category.equals((Object)AMD64.XMM)) {
                if (hasAVX512) {
                    asm.evmovdqu64(register, address);
                    continue;
                }
                if (hasAVX) {
                    asm.vmovdqu(register, address);
                    continue;
                }
                asm.movdqu(register, address);
                continue;
            }
            if (category.equals((Object)AMD64.MASK)) {
                throw VMError.unimplemented();
            }
            throw VMError.shouldNotReachHere();
        }
    }

    private AMD64Address calleeSaveAddress(AMD64MacroAssembler asm, int frameSize, Register register) {
        return asm.makeAddress(this.frameRegister, frameSize + this.getOffsetInFrame(register));
    }
}

