/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.MonitorSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.JavaLangSubstitutions;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.option.XOptions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.thread.ThreadIdRecomputation;
import com.oracle.svm.core.thread.ThreadStatusRecomputation;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.security.AccessControlContext;
import java.util.Map;
import java.util.Objects;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=Thread.class)
final class Target_java_lang_Thread {
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    volatile boolean interrupted;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    boolean wasStartedByCurrentIsolate;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=UninterruptibleUtils.AtomicReference.class)
    UninterruptibleUtils.AtomicReference<ParkEvent> unsafeParkEvent;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=UninterruptibleUtils.AtomicReference.class)
    UninterruptibleUtils.AtomicReference<ParkEvent> sleepParkEvent;
    @Alias
    ClassLoader contextClassLoader;
    @Alias
    volatile String name;
    @Alias
    int priority;
    @Alias
    boolean daemon;
    @Alias
    Runnable target;
    @Alias
    ThreadGroup group;
    @Alias
    long stackSize;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ThreadIdRecomputation.class)
    long tid;
    @Delete
    static long threadSeqNumber;
    @Delete
    static int threadInitNumber;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private AccessControlContext inheritedAccessControlContext;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ThreadStatusRecomputation.class)
    volatile int threadStatus;
    @Alias
    Object blockerLock;

    @Alias
    native void setPriority(int var1);

    @Substitute
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    @Substitute
    public void setContextClassLoader(ClassLoader cl) {
        this.contextClassLoader = cl;
    }

    @Substitute
    static long nextThreadID() {
        return JavaThreads.singleton().threadSeqNumber.incrementAndGet();
    }

    @Substitute
    private static int nextThreadNum() {
        return JavaThreads.singleton().threadInitNumber.incrementAndGet();
    }

    @Alias
    public native void exit();

    Target_java_lang_Thread(String withName, ThreadGroup withGroup, boolean asDaemon) {
        this.unsafeParkEvent = new UninterruptibleUtils.AtomicReference();
        this.sleepParkEvent = new UninterruptibleUtils.AtomicReference();
        this.tid = Target_java_lang_Thread.nextThreadID();
        this.threadStatus = 5;
        this.name = withName != null ? withName : "System-" + Target_java_lang_Thread.nextThreadNum();
        this.group = withGroup != null ? withGroup : JavaThreads.singleton().mainGroup;
        this.priority = 5;
        this.contextClassLoader = SubstrateUtil.cast(((JavaLangSubstitutions.ClassLoaderSupport)ImageSingletons.lookup(JavaLangSubstitutions.ClassLoaderSupport.class)).systemClassLoader, ClassLoader.class);
        this.blockerLock = new Object();
        this.daemon = asDaemon;
    }

    @Substitute
    static Thread currentThread() {
        Thread result = JavaThreads.currentThread.get();
        assert (result != null) : "java.lang.Thread not assigned when thread was attached to the VM";
        return result;
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private void init(ThreadGroup groupArg, Runnable targetArg, String nameArg, long stackSizeArg) {
        this.unsafeParkEvent = new UninterruptibleUtils.AtomicReference();
        this.sleepParkEvent = new UninterruptibleUtils.AtomicReference();
        JavaThreads.initializeNewThread(this, groupArg, targetArg, nameArg, stackSizeArg);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private Target_java_lang_Thread(ThreadGroup g, Runnable target, String name, long stackSize, AccessControlContext acc, boolean inheritThreadLocals) {
        this.blockerLock = new Object();
        this.unsafeParkEvent = new UninterruptibleUtils.AtomicReference();
        this.sleepParkEvent = new UninterruptibleUtils.AtomicReference();
        JavaThreads.initializeNewThread(this, g, target, name, stackSize);
    }

    @Substitute
    private void start0() {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            throw VMError.unsupportedFeature("Single-threaded VM cannot create new threads");
        }
        long chosenStackSize = 0L;
        if (this.stackSize != 0L) {
            chosenStackSize = this.stackSize;
        } else {
            int defaultThreadStackSize = (int)XOptions.getXss().getValue();
            if ((long)defaultThreadStackSize != 0L) {
                chosenStackSize = defaultThreadStackSize;
            }
        }
        if (chosenStackSize != 0L) {
            chosenStackSize += (long)StackOverflowCheck.singleton().yellowAndRedZoneSize();
        }
        this.threadStatus = 5;
        this.wasStartedByCurrentIsolate = true;
        JavaThreads.singleton().doStartThread(JavaThreads.fromTarget(this), chosenStackSize);
    }

    @Substitute
    protected void setNativeName(String name) {
        JavaThreads.singleton().setNativeName(JavaThreads.fromTarget(this), name);
    }

    @Substitute
    private void setPriority0(int priority) {
    }

    @Substitute
    private boolean isInterrupted(boolean clearInterrupted) {
        boolean result = this.interrupted;
        if (clearInterrupted) {
            this.interrupted = false;
        }
        return result;
    }

    @Substitute
    void interrupt0() {
        this.interrupted = true;
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        JavaThreads.interrupt(JavaThreads.fromTarget(this));
        JavaThreads.unpark(JavaThreads.fromTarget(this));
        JavaThreads.interruptVMCondVars();
    }

    @Substitute
    private void stop0(Object o) {
        throw VMError.unsupportedFeature("The deprecated method Thread.stop is not supported");
    }

    @Substitute
    private void suspend0() {
        throw VMError.unsupportedFeature("The deprecated method Thread.suspend is not supported");
    }

    @Substitute
    private void resume0() {
        throw VMError.unsupportedFeature("The deprecated method Thread.resume is not supported");
    }

    @Substitute
    private int countStackFrames() {
        throw VMError.unsupportedFeature("The deprecated method Thread.countStackFrames is not supported");
    }

    @Delete
    private static native void registerNatives();

    @Delete
    private static native StackTraceElement[][] dumpThreads(Thread[] var0);

    @Delete
    private static native Thread[] getThreads();

    @Substitute
    private boolean isAlive() {
        return this.threadStatus != 0 && this.threadStatus != 2;
    }

    @Substitute
    private static void yield() {
        JavaThreads.singleton().yield();
    }

    @Substitute
    private static void sleep(long millis) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        ParkEvent.WaitResult sleepResult = JavaThreads.sleep(TimeUtils.millisToNanos(millis));
        boolean interrupted = Thread.interrupted();
        if (sleepResult == ParkEvent.WaitResult.UNPARKED || sleepResult == ParkEvent.WaitResult.INTERRUPTED || interrupted) {
            throw new InterruptedException();
        }
    }

    @Substitute
    private static boolean holdsLock(Object obj) {
        Objects.requireNonNull(obj);
        return ((MonitorSupport)ImageSingletons.lookup(MonitorSupport.class)).holdsLock(obj);
    }

    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private StackTraceElement[] getStackTrace() {
        if (JavaThreads.fromTarget(this) == Thread.currentThread()) {
            return StackTraceUtils.getStackTrace(false, KnownIntrinsics.readCallerStackPointer());
        }
        return JavaThreads.getStackTrace(JavaThreads.fromTarget(this));
    }

    @Substitute
    private static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        return JavaThreads.getAllStackTraces();
    }
}

