/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.posix.headers.Limits;
import com.oracle.svm.core.posix.headers.Pwd;
import com.oracle.svm.core.posix.headers.Unistd;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.WordFactory;

@Platforms(value={InternalPlatform.LINUX_JNI_AND_SUBSTITUTIONS.class, InternalPlatform.DARWIN_JNI_AND_SUBSTITUTIONS.class})
public abstract class PosixSystemPropertiesSupport
extends SystemPropertiesSupport {
    @Override
    protected String userNameValue() {
        Pwd.passwd pwent = Pwd.getpwuid(Unistd.getuid());
        return pwent.isNull() ? "?" : CTypeConversion.toJavaString((CCharPointer)pwent.pw_name());
    }

    @Override
    protected String userHomeValue() {
        Pwd.passwd pwent = Pwd.getpwuid(Unistd.getuid());
        return pwent.isNull() ? "?" : CTypeConversion.toJavaString((CCharPointer)pwent.pw_dir());
    }

    @Override
    protected String userDirValue() {
        int bufSize = Limits.MAXPATHLEN();
        CCharPointer buf = (CCharPointer)StackValue.get((int)bufSize);
        if (Unistd.getcwd(buf, WordFactory.unsigned((int)bufSize)).isNonNull()) {
            return CTypeConversion.toJavaString((CCharPointer)buf);
        }
        throw new Error("Properties init: Could not determine current working directory.");
    }
}

