/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.annotate.UnknownObjectField;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class StaticFieldsSupport {
    @UnknownObjectField(types={Object[].class})
    private Object[] staticObjectFields;
    @UnknownObjectField(types={byte[].class})
    private byte[] staticPrimitiveFields;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected StaticFieldsSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setData(Object[] staticObjectFields, byte[] staticPrimitiveFields) {
        StaticFieldsSupport support = (StaticFieldsSupport)ImageSingletons.lookup(StaticFieldsSupport.class);
        support.staticObjectFields = staticObjectFields;
        support.staticPrimitiveFields = staticPrimitiveFields;
    }

    public static Object[] getStaticObjectFields() {
        Object[] result = ((StaticFieldsSupport)ImageSingletons.lookup(StaticFieldsSupport.class)).staticObjectFields;
        assert (result != null);
        return result;
    }

    public static byte[] getStaticPrimitiveFields() {
        byte[] result = ((StaticFieldsSupport)ImageSingletons.lookup(StaticFieldsSupport.class)).staticPrimitiveFields;
        assert (result != null);
        return result;
    }
}

