/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.JniProcessor;
import com.oracle.svm.configure.trace.ReflectionProcessor;
import com.oracle.svm.core.util.json.JSONParser;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;

public class TraceProcessor
extends AbstractProcessor {
    private final AccessAdvisor advisor = new AccessAdvisor();
    private final JniProcessor jniProcessor;
    private final ReflectionProcessor reflectionProcessor;

    public TraceProcessor(TypeConfiguration jniConfiguration, TypeConfiguration reflectionConfiguration, ProxyConfiguration proxyConfiguration, ResourceConfiguration resourceConfiguration) {
        this.jniProcessor = new JniProcessor(this.advisor, jniConfiguration, reflectionConfiguration);
        this.reflectionProcessor = new ReflectionProcessor(this.advisor, reflectionConfiguration, proxyConfiguration, resourceConfiguration);
    }

    public void setFilterEnabled(boolean enabled) {
        this.advisor.setIgnoreInternalAccesses(enabled);
    }

    public TypeConfiguration getJniConfiguration() {
        return this.jniProcessor.getConfiguration();
    }

    public TypeConfiguration getReflectionConfiguration() {
        return this.reflectionProcessor.getConfiguration();
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.reflectionProcessor.getProxyConfiguration();
    }

    public ResourceConfiguration getResourceConfiguration() {
        return this.reflectionProcessor.getResourceConfiguration();
    }

    public void process(Reader reader) throws IOException {
        this.setInLivePhase(false);
        JSONParser parser = new JSONParser(reader);
        List trace = (List)parser.parse();
        this.processTrace(trace);
    }

    private void processTrace(List<Map<String, ?>> trace) {
        for (Map<String, ?> entry : trace) {
            this.processEntry(entry);
        }
    }

    @Override
    public void processEntry(Map<String, ?> entry) {
        try {
            String tracer;
            switch (tracer = (String)entry.get("tracer")) {
                case "meta": {
                    String event = (String)entry.get("event");
                    if (event.equals("phase_change")) {
                        this.setInLivePhase(entry.get("phase").equals("live"));
                        break;
                    }
                    if (event.equals("initialization")) break;
                    TraceProcessor.logWarning("Unknown meta event, ignoring: " + event);
                    break;
                }
                case "jni": {
                    this.jniProcessor.processEntry(entry);
                    break;
                }
                case "reflect": {
                    this.reflectionProcessor.processEntry(entry);
                    break;
                }
                default: {
                    TraceProcessor.logWarning("Unknown tracer, ignoring: " + tracer);
                }
            }
        }
        catch (Exception e) {
            TraceProcessor.logWarning("Error processing trace entry: " + e.toString() + ": " + entry.toString());
        }
    }

    @Override
    void setInLivePhase(boolean live) {
        this.advisor.setInLivePhase(live);
        this.jniProcessor.setInLivePhase(live);
        this.reflectionProcessor.setInLivePhase(live);
        super.setInLivePhase(live);
    }
}

