/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.restrict;

import com.oracle.svm.agent.Support;
import com.oracle.svm.agent.restrict.AbstractAccessVerifier;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;

public class ResourceAccessVerifier
extends AbstractAccessVerifier {
    private final ResourceConfiguration configuration;

    public ResourceAccessVerifier(ResourceConfiguration configuration, AccessAdvisor advisor) {
        super(advisor);
        this.configuration = configuration;
    }

    public boolean verifyGetResources(JNIEnvironment env, JNIObjectHandle name, JNIObjectHandle callerClass) {
        return this.verifyGetResources0(env, name, callerClass);
    }

    public boolean verifyGetSystemResources(JNIEnvironment env, JNIObjectHandle name, JNIObjectHandle callerClass) {
        return this.verifyGetResources0(env, name, callerClass);
    }

    private boolean verifyGetResources0(JNIEnvironment env, JNIObjectHandle name, JNIObjectHandle callerClass) {
        String resource = Support.fromJniString(env, name);
        return this.configuration.anyMatches(resource);
    }
}

