/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import com.oracle.objectfile.elf.dwarf.constants.DwarfSectionName;
import java.util.Map;
import jdk.graal.compiler.debug.DebugContext;

public class DwarfRangesSectionImpl
extends DwarfSectionImpl {
    public DwarfRangesSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections, DwarfSectionName.DW_RANGES_SECTION, DwarfSectionName.DW_ARANGES_SECTION);
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this);
        this.instanceClassStream().filter(ClassEntry::hasCompiledEntries).forEachOrdered(classEntry -> {
            this.setCodeRangesIndex((ClassEntry)classEntry, cursor.get());
            cursor.add(16);
            cursor.add(16 * classEntry.compiledEntryCount());
            cursor.add(16);
        });
        byte[] buffer = new byte[cursor.get()];
        super.setContent(buffer);
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        Object valueObj;
        ObjectFile.Element textElement = this.getElement().getOwner().elementForName(".text");
        LayoutDecisionMap decisionMap = alreadyDecided.get(textElement);
        if (decisionMap != null && (valueObj = decisionMap.getDecidedValue(LayoutDecision.Kind.VADDR)) != null && valueObj instanceof Number) {
            this.debugTextBase = ((Number)valueObj).longValue();
        }
        return super.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this);
        this.enableLog(context, cursor.get());
        this.log(context, "  [0x%08x] DEBUG_RANGES", cursor.get());
        this.instanceClassStream().filter(ClassEntry::hasCompiledEntries).forEachOrdered(classEntry -> {
            int pos;
            int start = pos = cursor.get();
            this.setCodeRangesIndex((ClassEntry)classEntry, pos);
            this.log(context, "  [0x%08x] ranges start for class %s", pos, classEntry.getTypeName());
            int base = classEntry.compiledEntriesBase();
            this.log(context, "  [0x%08x] base 0x%x", pos, base);
            pos = this.writeLong(-1L, buffer, pos);
            pos = this.writeRelocatableCodeOffset(base, buffer, pos);
            cursor.set(pos);
            classEntry.compiledEntries().forEach(compiledMethodEntry -> {
                int lo = compiledMethodEntry.getPrimary().getLo();
                int hi = compiledMethodEntry.getPrimary().getHi();
                this.log(context, "  [0x%08x] lo 0x%x (%s)", cursor.get(), lo - base, compiledMethodEntry.getPrimary().getFullMethodNameWithParams());
                cursor.set(this.writeLong(lo - base, buffer, cursor.get()));
                this.log(context, "  [0x%08x] hi 0x%x", cursor.get(), hi - base);
                cursor.set(this.writeLong(hi - base, buffer, cursor.get()));
            });
            pos = cursor.get();
            pos = this.writeLong(0L, buffer, pos);
            pos = this.writeLong(0L, buffer, pos);
            this.log(context, "  [0x%08x] ranges size 0x%x  for class %s", pos, pos - start, classEntry.getTypeName());
            cursor.set(pos);
        });
        assert (cursor.get() == size);
    }
}

