/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.elf.ELFMachine;
import com.oracle.objectfile.elf.ELFObjectFile;
import com.oracle.objectfile.elf.ELFRelocationSection;
import com.oracle.objectfile.elf.ELFSymtab;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;

public class ELFUserDefinedSection
extends ELFObjectFile.ELFSection
implements ObjectFile.RelocatableSectionImpl {
    private ELFRelocationSection rel;
    private ELFRelocationSection rela;
    protected ElementImpl impl;

    @Override
    public ElementImpl getImpl() {
        return this.impl;
    }

    ELFUserDefinedSection(ELFObjectFile owner, String name, int alignment, ELFObjectFile.SectionType type, ElementImpl impl) {
        this(owner, name, alignment, type, impl, EnumSet.noneOf(ELFObjectFile.ELFSectionFlag.class));
    }

    ELFUserDefinedSection(ELFObjectFile owner, String name, int alignment, ELFObjectFile.SectionType type, ElementImpl impl, EnumSet<ELFObjectFile.ELFSectionFlag> flags) {
        this(owner, name, alignment, type, impl, flags, -1);
    }

    ELFUserDefinedSection(ELFObjectFile owner, String name, int alignment, ELFObjectFile.SectionType type, ElementImpl impl, EnumSet<ELFObjectFile.ELFSectionFlag> flags, int sectionIndex) {
        ELFObjectFile eLFObjectFile = owner;
        Objects.requireNonNull(eLFObjectFile);
        super(name, alignment, type, flags, sectionIndex);
        this.impl = impl;
    }

    public void setImpl(ElementImpl impl) {
        assert (impl == null);
        this.impl = impl;
        if (impl.isLoadable()) {
            this.flags.add(ELFObjectFile.ELFSectionFlag.ALLOC);
        } else {
            this.flags.remove(ELFObjectFile.ELFSectionFlag.ALLOC);
        }
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        return this.impl.getDependencies(decisions);
    }

    @Override
    public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
        return this.impl.getOrDecideOffset(alreadyDecided, offsetHint);
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return this.impl.getOrDecideSize(alreadyDecided, sizeHint);
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        return this.impl.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
        return this.impl.getOrDecideVaddr(alreadyDecided, vaddrHint);
    }

    @Override
    public int getMemSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
        return this.impl.getMemSize(alreadyDecided);
    }

    @Override
    public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
        return this.impl.getDecisions(copyingIn);
    }

    @Override
    public ObjectFile.Element getOrCreateRelocationElement(long addend) {
        ELFSymtab syms = (ELFSymtab)this.getOwner().elementForName(".symtab");
        if (syms == null) {
            throw new IllegalStateException("Cannot create a relocation section without corresponding symtab");
        }
        if (ELFObjectFile.useExplicitAddend(addend)) {
            if (this.rela == null) {
                this.rela = this.getOwner().getOrCreateRelocSection(this, syms, true);
                assert (this.rela != null);
            }
            return this.rela;
        }
        if (this.rel == null) {
            this.rel = this.getOwner().getOrCreateRelocSection(this, syms, false);
            assert (this.rel != null);
        }
        return this.rel;
    }

    @Override
    public void markRelocationSite(int offset, ByteBuffer bb, ObjectFile.RelocationKind k, String symbolName, long addend) {
        ELFSymtab syms = (ELFSymtab)this.getOwner().elementForName(".symtab");
        ELFRelocationSection rs = (ELFRelocationSection)this.getOrCreateRelocationElement(addend);
        assert (symbolName != null);
        ELFSymtab.Entry ent = syms.getSymbol(symbolName);
        assert (ent != null) : "Symbol name not defined: " + symbolName;
        rs.addEntry(this, offset, ELFMachine.getRelocation(this.getOwner().getMachine(), k), ent, addend);
    }
}

