/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff;

import com.oracle.objectfile.pecoff.PECoff;
import com.oracle.objectfile.pecoff.PECoffByteBuffer;
import java.nio.ByteBuffer;

public class PECoffHeaderStruct {
    private final ByteBuffer header = PECoffByteBuffer.allocate(PECoff.IMAGE_FILE_HEADER.totalsize);

    public PECoffHeaderStruct() {
        this.header.putChar(PECoff.IMAGE_FILE_HEADER.Machine.off, '\u8664');
        this.header.putInt(PECoff.IMAGE_FILE_HEADER.TimeDateStamp.off, (int)(System.currentTimeMillis() / 1000L));
        this.header.putInt(PECoff.IMAGE_FILE_HEADER.PointerToSymbolTable.off, 0);
        this.header.putInt(PECoff.IMAGE_FILE_HEADER.NumberOfSymbols.off, 0);
        this.header.putChar(PECoff.IMAGE_FILE_HEADER.SizeOfOptionalHeader.off, '\u0000');
        this.header.putChar(PECoff.IMAGE_FILE_HEADER.Characteristics.off, '\u0000');
    }

    void setSectionCount(int count) {
        this.header.putChar(PECoff.IMAGE_FILE_HEADER.NumberOfSections.off, (char)count);
    }

    void setSymbolCount(int count) {
        this.header.putInt(PECoff.IMAGE_FILE_HEADER.NumberOfSymbols.off, count);
    }

    void setSymbolOff(int offset) {
        this.header.putInt(PECoff.IMAGE_FILE_HEADER.PointerToSymbolTable.off, offset);
    }

    byte[] getArray() {
        return this.header.array();
    }
}

