/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.DirEntry;

public class FileEntry {
    private String fileName;
    private DirEntry dirEntry;
    private String cachePath;

    public FileEntry(String fileName, DirEntry dirEntry, String cachePath) {
        this.fileName = fileName;
        this.dirEntry = dirEntry;
        this.cachePath = cachePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathName() {
        return this.getDirEntry().getPathString();
    }

    public String getFullName() {
        return this.getDirEntry() != null ? this.getDirEntry().getPath().resolve(this.getFileName()).toString() : this.getFileName();
    }

    public DirEntry getDirEntry() {
        return this.dirEntry;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public String toString() {
        if (this.getDirEntry() == null) {
            return this.getFileName() == null ? "-" : this.getFileName();
        }
        if (this.getFileName() == null) {
            return "--";
        }
        return String.format("FileEntry(%s)", this.getFullName());
    }
}

