/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types.symbols;

import java.util.regex.Pattern;

public final class LLVMIdentifier {
    public static final String UNKNOWN = "<anon>";
    private static final Pattern GLOBAL_VARNAME_PATTERN = Pattern.compile("@(\\\\01)?(\"[^\"]+\"|[\\w\\d\\u0024_\\u002e]+)");
    private static final Pattern LOCAL_VARNAME_PATTERN = Pattern.compile("%(\"[^\"]+\"|[\\w\\d\\u0024_\\u002e]+)");
    private static final Pattern UNESCAPED_VARNAME_PATTERN = Pattern.compile("[\\w\\d\\u0024_\\u002e]+");
    private static final Pattern ESCAPED_VARNAME_PATTERN = Pattern.compile("(%|@|@\\\\01)?\"[^\"]+\"");

    private LLVMIdentifier() {
    }

    private static Object asObject(String value) {
        return value;
    }

    public static boolean isUnknown(Object name) {
        return name == LLVMIdentifier.asObject(UNKNOWN);
    }

    public static String toGlobalIdentifier(String name) {
        if (GLOBAL_VARNAME_PATTERN.matcher(name).matches()) {
            return name;
        }
        return "@" + LLVMIdentifier.escapeNameIfNecessary(name);
    }

    public static String toLocalIdentifier(String name) {
        if (LOCAL_VARNAME_PATTERN.matcher(name).matches()) {
            return name;
        }
        return "%" + LLVMIdentifier.escapeNameIfNecessary(name);
    }

    public static String toImplicitBlockName(int label) {
        return String.format("%d", label);
    }

    private static String escapeNameIfNecessary(String unescaped) {
        if (UNESCAPED_VARNAME_PATTERN.matcher(unescaped).matches()) {
            return unescaped;
        }
        if (ESCAPED_VARNAME_PATTERN.matcher(unescaped).matches()) {
            return unescaped;
        }
        StringBuilder builder = new StringBuilder("\"");
        for (int i = 0; i < unescaped.length(); ++i) {
            char c = unescaped.charAt(i);
            if (c == '\"' || c < ' ' || c > '~') {
                builder.append(String.format("\\%02x", c & 0xFF));
                continue;
            }
            builder.append(c);
        }
        builder.append('\"');
        return builder.toString();
    }
}

