/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropInvokeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMResolveForeignClassChainNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsDateTimeNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotNativeBufferInfo;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotReadBuffer;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotWriteBuffer;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class, receiverType=LLVMPointerImpl.class), @ExportLibrary(value=LLVMManagedWriteLibrary.class, receiverType=LLVMPointerImpl.class, useForAOT=true, useForAOTPriority=1), @ExportLibrary(value=LLVMManagedReadLibrary.class, receiverType=LLVMPointerImpl.class, useForAOT=true, useForAOTPriority=2)})
abstract class CommonPointerLibraries {
    CommonPointerLibraries() {
    }

    @ExportMessage
    static boolean isReadable(LLVMPointerImpl receiver) {
        return false;
    }

    @ExportMessage
    static byte readI8(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type I8 directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static short readI16(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type I16 directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static int readI32(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type I32 directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static float readFloat(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type Float directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static long readI64(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type I64 directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static double readDouble(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type Double directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static LLVMPointer readPointer(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type Pointer directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static Object readGenericI64(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type Object directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static boolean isWritable(LLVMPointerImpl receiver) {
        return false;
    }

    @ExportMessage
    static void writeI8(LLVMPointerImpl receiver, long offset, byte value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type I8 directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writeI16(LLVMPointerImpl receiver, long offset, short value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type I16 directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writeI32(LLVMPointerImpl receiver, long offset, int value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type I32 directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writeFloat(LLVMPointerImpl receiver, long offset, float value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type Float directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writeI64(LLVMPointerImpl receiver, long offset, long value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type I64 directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writeGenericI64(LLVMPointerImpl receiver, long offset, Object value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type Object directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writeDouble(LLVMPointerImpl receiver, long offset, double value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type Double directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writePointer(LLVMPointerImpl receiver, long offset, LLVMPointer value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type Pointer directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static boolean isDate(LLVMPointerImpl receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.Instant || receiver.getExportType() instanceof LLVMInteropType.TimeInfo;
    }

    @ExportMessage
    static LocalDate asDate(LLVMPointerImpl receiver, @Cached LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsDateNode asDate) throws UnsupportedMessageException {
        return asDate.execute(receiver);
    }

    @ExportMessage
    static boolean isTime(LLVMPointerImpl receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.Instant || receiver.getExportType() instanceof LLVMInteropType.TimeInfo;
    }

    @ExportMessage
    static LocalTime asTime(LLVMPointerImpl receiver, @Cached LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsTimeNode asTime) throws UnsupportedMessageException {
        return asTime.execute(receiver);
    }

    @ExportMessage
    static boolean isTimeZone(LLVMPointerImpl receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.Instant;
    }

    @ExportMessage
    static ZoneId asTimeZone(LLVMPointerImpl receiver, @Cached LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsTimeZoneNode asTimeZone) throws UnsupportedMessageException {
        return asTimeZone.execute(receiver);
    }

    @ExportMessage
    static Instant asInstant(LLVMPointerImpl receiver, @Cached LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsInstantNode inst) throws UnsupportedMessageException {
        return inst.execute(receiver);
    }

    @ExportMessage
    static boolean hasMembers(LLVMPointerImpl receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.Struct;
    }

    @ExportMessage
    static Object getMembers(LLVMPointerImpl receiver, boolean includeInternal, @Cached.Shared(value="isObject") @Cached ConditionProfile isObject) throws UnsupportedMessageException {
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Clazz)) {
            LLVMInteropType.Clazz clazz = (LLVMInteropType.Clazz)receiver.getExportType();
            return new ClassKeys(clazz);
        }
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Struct)) {
            LLVMInteropType.Struct struct = (LLVMInteropType.Struct)receiver.getExportType();
            return new Keys(struct);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isMemberReadable(LLVMPointerImpl receiver, String ident, @Cached.Shared(value="isObject") @Cached ConditionProfile isObject) {
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Clazz)) {
            LLVMInteropType.Clazz clazz = (LLVMInteropType.Clazz)receiver.getExportType();
            LLVMInteropType.StructMember member = clazz.findMember(ident);
            if (member == null) {
                LLVMInteropType.Method method = clazz.findMethod(ident);
                return method != null;
            }
            return member != null;
        }
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Struct)) {
            LLVMInteropType.Struct struct = (LLVMInteropType.Struct)receiver.getExportType();
            LLVMInteropType.StructMember member = struct.findMember(ident);
            return member != null;
        }
        return false;
    }

    @ExportMessage
    static Object readMember(LLVMPointerImpl receiver, String ident, @Cached.Shared(value="getDirectClass") @Cached LLVMResolveForeignClassChainNode resolveClassChain, @Cached.Shared(value="getMember") @Cached LLVMForeignGetMemberPointerNode getElementPointer, @Cached.Exclusive @Cached LLVMForeignReadNode read) throws UnsupportedMessageException, UnknownIdentifierException {
        LLVMPointer correctClassPtr = resolveClassChain.execute(receiver, ident, receiver.getExportType());
        LLVMPointer ptr = getElementPointer.execute(correctClassPtr.getExportType(), correctClassPtr, ident);
        return read.execute(ptr, ptr.getExportType());
    }

    @ExportMessage
    static boolean isMemberModifiable(LLVMPointerImpl receiver, String ident, @Cached.Shared(value="isObject") @Cached ConditionProfile isObject) {
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Struct)) {
            LLVMInteropType.Struct struct = (LLVMInteropType.Struct)receiver.getExportType();
            LLVMInteropType.StructMember member = struct.findMember(ident);
            if (member == null) {
                return false;
            }
            return member.type instanceof LLVMInteropType.Value;
        }
        return false;
    }

    @ExportMessage
    static boolean isMemberInvocable(LLVMPointerImpl receiver, String ident, @CachedLibrary(limit="5") InteropLibrary interop) {
        LLVMInteropType type = receiver.getExportType();
        if (type instanceof LLVMInteropType.Clazz && ((LLVMInteropType.Clazz)type).findMethod(ident) != null) {
            return true;
        }
        try {
            if (interop.isMemberReadable((Object)receiver, ident)) {
                Object member = interop.readMember((Object)receiver, ident);
                return interop.isExecutable(member);
            }
        }
        catch (UnknownIdentifierException | UnsupportedMessageException throwable) {
            // empty catch block
        }
        return false;
    }

    static LLVMInteropType.Clazz asClazz(LLVMPointerImpl receiver) throws UnsupportedMessageException {
        LLVMInteropType type = receiver.getExportType();
        if (!(type instanceof LLVMInteropType.Clazz)) {
            throw UnsupportedMessageException.create();
        }
        return (LLVMInteropType.Clazz)type;
    }

    @ExportMessage
    static Object invokeMember(LLVMPointerImpl receiver, String member, Object[] arguments, @Cached LLVMInteropInvokeNode invoke) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
        return invoke.execute(receiver, receiver.getExportType(), member, arguments);
    }

    @ExportMessage
    static boolean isMemberInsertable(LLVMPointerImpl receiver, String ident) {
        return false;
    }

    @ExportMessage
    static void writeMember(LLVMPointerImpl receiver, String ident, Object value, @Cached.Shared(value="getDirectClass") @Cached LLVMResolveForeignClassChainNode resolveClassChain, @Cached.Shared(value="getMember") @Cached LLVMForeignGetMemberPointerNode getElementPointer, @Cached.Exclusive @Cached LLVMForeignWriteNode write) throws UnsupportedMessageException, UnknownIdentifierException {
        LLVMPointer correctClassPtr = resolveClassChain.execute(receiver, ident, receiver.getExportType());
        LLVMPointer ptr = getElementPointer.execute(correctClassPtr.getExportType(), correctClassPtr, ident);
        write.execute(ptr, ptr.getExportType(), value);
    }

    @ExportMessage
    static boolean hasArrayElements(LLVMPointerImpl receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.Array;
    }

    @ExportMessage
    static long getArraySize(LLVMPointerImpl receiver, @Cached.Shared(value="isArray") @Cached ConditionProfile isArray) throws UnsupportedMessageException {
        if (isArray.profile(receiver.getExportType() instanceof LLVMInteropType.Array)) {
            return ((LLVMInteropType.Array)receiver.getExportType()).length;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isArrayElementReadable(LLVMPointerImpl receiver, long idx, @Cached.Shared(value="isArray") @Cached ConditionProfile isArray) {
        if (isArray.profile(receiver.getExportType() instanceof LLVMInteropType.Array)) {
            long length = ((LLVMInteropType.Array)receiver.getExportType()).length;
            return Long.compareUnsigned(idx, length) < 0;
        }
        return false;
    }

    @ExportMessage
    static Object readArrayElement(LLVMPointerImpl receiver, long idx, @Cached.Shared(value="getIndex") @Cached LLVMForeignGetIndexPointerNode getElementPointer, @Cached.Exclusive @Cached LLVMForeignReadNode read) throws UnsupportedMessageException, InvalidArrayIndexException {
        LLVMPointer ptr = getElementPointer.execute(receiver.getExportType(), receiver, idx);
        return read.execute(ptr, ptr.getExportType());
    }

    @ExportMessage
    static boolean isArrayElementModifiable(LLVMPointerImpl receiver, long idx, @Cached.Shared(value="isArray") @Cached ConditionProfile isArray) {
        if (isArray.profile(receiver.getExportType() instanceof LLVMInteropType.Array)) {
            LLVMInteropType.Array arrayType = (LLVMInteropType.Array)receiver.getExportType();
            if (arrayType.elementType instanceof LLVMInteropType.Value) {
                long length = arrayType.length;
                return Long.compareUnsigned(idx, length) < 0;
            }
            return false;
        }
        return false;
    }

    @ExportMessage
    static boolean isArrayElementInsertable(LLVMPointerImpl receiver, long idx) {
        return false;
    }

    @ExportMessage
    static void writeArrayElement(LLVMPointerImpl receiver, long idx, Object value, @Cached.Shared(value="getIndex") @Cached LLVMForeignGetIndexPointerNode getElementPointer, @Cached.Exclusive @Cached LLVMForeignWriteNode write) throws UnsupportedMessageException, InvalidArrayIndexException {
        LLVMPointer ptr = getElementPointer.execute(receiver.getExportType(), receiver, idx);
        write.execute(ptr, ptr.getExportType(), value);
    }

    @ExportMessage
    static boolean hasLanguage(LLVMPointerImpl receiver) {
        return true;
    }

    @ExportMessage
    static Class<? extends TruffleLanguage<?>> getLanguage(LLVMPointerImpl receiver) {
        return LLVMLanguage.class;
    }

    @ExportMessage
    static String toDisplayString(LLVMPointerImpl receiver, boolean allowSideEffects) {
        throw CompilerDirectives.shouldNotReachHere((String)"should be overridden");
    }

    @ExportMessage
    static Object getMetaObject(LLVMPointerImpl receiver) throws UnsupportedMessageException {
        LLVMInteropType type = receiver.getExportType();
        if (type != null) {
            return type;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasMetaObject(LLVMPointerImpl receiver) {
        return receiver.getExportType() != null;
    }

    @ExportMessage
    static int identityHashCode(LLVMPointerImpl receiver) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError();
    }

    @ExportMessage
    static boolean hasBufferElements(LLVMPointerImpl receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.Buffer;
    }

    @ExportMessage
    static long getBufferSize(LLVMPointerImpl receiver, @Cached LLVMPolyglotNativeBufferInfo.GetBufferSize getSize) throws UnsupportedMessageException {
        return getSize.execute(receiver);
    }

    @ExportMessage
    static byte readBufferByte(LLVMPointerImpl receiver, long byteOffset, @Cached LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferByteNode read) throws UnsupportedMessageException, InvalidBufferOffsetException {
        return read.execute(receiver, byteOffset);
    }

    @ExportMessage
    static void readBuffer(LLVMPointerImpl receiver, long byteOffset, byte[] destination, int destinationOffset, int length, @Cached LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferNode read) throws UnsupportedMessageException, InvalidBufferOffsetException {
        read.execute(receiver, byteOffset, destination, destinationOffset, length);
    }

    @ExportMessage
    static void writeBufferByte(LLVMPointerImpl receiver, long byteOffset, byte value, @Cached LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferByteNode write) throws UnsupportedMessageException, InvalidBufferOffsetException {
        write.execute(receiver, byteOffset, value);
    }

    @ExportMessage
    static short readBufferShort(LLVMPointerImpl receiver, ByteOrder order, long byteOffset, @Cached LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferShortNode read) throws UnsupportedMessageException, InvalidBufferOffsetException {
        return read.execute(receiver, order, byteOffset);
    }

    @ExportMessage
    static void writeBufferShort(LLVMPointerImpl receiver, ByteOrder order, long byteOffset, short value, @Cached LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferShortNode write) throws UnsupportedMessageException, InvalidBufferOffsetException {
        write.execute(receiver, order, byteOffset, value);
    }

    @ExportMessage
    static int readBufferInt(LLVMPointerImpl receiver, ByteOrder order, long byteOffset, @Cached LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferIntNode read) throws UnsupportedMessageException, InvalidBufferOffsetException {
        return read.execute(receiver, order, byteOffset);
    }

    @ExportMessage
    static void writeBufferInt(LLVMPointerImpl receiver, ByteOrder order, long byteOffset, int value, @Cached LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferIntNode write) throws UnsupportedMessageException, InvalidBufferOffsetException {
        write.execute(receiver, order, byteOffset, value);
    }

    @ExportMessage
    static long readBufferLong(LLVMPointerImpl receiver, ByteOrder order, long byteOffset, @Cached LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferLongNode read) throws UnsupportedMessageException, InvalidBufferOffsetException {
        return read.execute(receiver, order, byteOffset);
    }

    @ExportMessage
    static void writeBufferLong(LLVMPointerImpl receiver, ByteOrder order, long byteOffset, long value, @Cached LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferLongNode write) throws UnsupportedMessageException, InvalidBufferOffsetException {
        write.execute(receiver, order, byteOffset, value);
    }

    @ExportMessage
    static float readBufferFloat(LLVMPointerImpl receiver, ByteOrder order, long byteOffset, @Cached LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferFloatNode read) throws UnsupportedMessageException, InvalidBufferOffsetException {
        return read.execute(receiver, order, byteOffset);
    }

    @ExportMessage
    static void writeBufferFloat(LLVMPointerImpl receiver, ByteOrder order, long byteOffset, float value, @Cached LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferFloatNode write) throws UnsupportedMessageException, InvalidBufferOffsetException {
        write.execute(receiver, order, byteOffset, value);
    }

    @ExportMessage
    static double readBufferDouble(LLVMPointerImpl receiver, ByteOrder order, long byteOffset, @Cached LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferDoubleNode read) throws UnsupportedMessageException, InvalidBufferOffsetException {
        return read.execute(receiver, order, byteOffset);
    }

    @ExportMessage
    static void writeBufferDouble(LLVMPointerImpl receiver, ByteOrder order, long byteOffset, double value, @Cached LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferDoubleNode write) throws UnsupportedMessageException, InvalidBufferOffsetException {
        write.execute(receiver, order, byteOffset, value);
    }

    @ExportMessage
    static boolean isBufferWritable(LLVMPointerImpl receiver, @Cached LLVMPolyglotNativeBufferInfo.IsBufferWritable isWritable) throws UnsupportedMessageException {
        return isWritable.execute(receiver);
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class ClassKeys
    implements TruffleObject {
        private final LLVMInteropType.Clazz type;

        private ClassKeys(LLVMInteropType.Clazz type) {
            this.type = type;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.type.getMemberCount() + this.type.getMethodCount();
        }

        @ExportMessage
        boolean isArrayElementReadable(long idx) {
            return Long.compareUnsigned(idx, this.getArraySize()) < 0;
        }

        @ExportMessage
        Object readArrayElement(long idx, @Cached BranchProfile exception) throws InvalidArrayIndexException {
            try {
                int index = (int)idx;
                if (index < this.type.getMemberCount()) {
                    return this.type.getMember((int)index).name;
                }
                return this.type.getMethod(index - this.type.getMemberCount()).getName();
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw InvalidArrayIndexException.create((long)idx);
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class Keys
    implements TruffleObject {
        private final LLVMInteropType.Struct type;

        private Keys(LLVMInteropType.Struct type) {
            this.type = type;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.type.getMemberCount();
        }

        @ExportMessage
        boolean isArrayElementReadable(long idx) {
            return Long.compareUnsigned(idx, this.getArraySize()) < 0;
        }

        @ExportMessage
        Object readArrayElement(long idx, @Cached BranchProfile exception) throws InvalidArrayIndexException {
            try {
                return this.type.getMember((int)((int)idx)).name;
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw InvalidArrayIndexException.create((long)idx);
            }
        }
    }

    @ExportMessage
    static class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doPointer(LLVMPointerImpl receiver, LLVMPointerImpl other, @Cached LLVMAddressEqualsNode.Operation equals) {
            return TriState.valueOf((boolean)equals.executeWithTarget(receiver, other));
        }

        @Fallback
        static TriState doOther(LLVMPointerImpl receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }
}

