/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vector;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

public abstract class LLVMExtractElementNode {

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMDoubleExtractElementNode
    extends LLVMExpressionNode {
        @Specialization
        protected double doDouble(LLVMDoubleVector vector, int index) {
            return vector.getValue(index);
        }

        @Specialization
        protected double doDouble(LLVMDoubleVector vector, long index) {
            return vector.getValue(Math.toIntExact(index));
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMFloatExtractElementNode
    extends LLVMExpressionNode {
        @Specialization
        protected float doFloat(LLVMFloatVector vector, int index) {
            return vector.getValue(index);
        }

        @Specialization
        protected float doFloat(LLVMFloatVector vector, long index) {
            return vector.getValue(Math.toIntExact(index));
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMI64ExtractElementNode
    extends LLVMExpressionNode {
        @Specialization
        protected long doI64(LLVMI64Vector vector, int index) {
            return vector.getValue(index);
        }

        @Specialization
        protected long doI64(LLVMI64Vector vector, long index) {
            return vector.getValue(Math.toIntExact(index));
        }

        @Specialization
        protected LLVMPointer doPointer(LLVMPointerVector vector, int index) {
            return vector.getValue(index);
        }

        @Specialization
        protected LLVMPointer doPointer(LLVMPointerVector vector, long index) {
            return vector.getValue(Math.toIntExact(index));
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMI32ExtractElementNode
    extends LLVMExpressionNode {
        @Specialization
        protected int doI32(LLVMI32Vector vector, int index) {
            return vector.getValue(index);
        }

        @Specialization
        protected int doI32(LLVMI32Vector vector, long index) {
            return vector.getValue(Math.toIntExact(index));
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMI16ExtractElementNode
    extends LLVMExpressionNode {
        @Specialization
        protected short doI16(LLVMI16Vector vector, int index) {
            return vector.getValue(index);
        }

        @Specialization
        protected short doI16(LLVMI16Vector vector, long index) {
            return vector.getValue(Math.toIntExact(index));
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMI8ExtractElementNode
    extends LLVMExpressionNode {
        @Specialization
        protected byte doI8(LLVMI8Vector vector, int index) {
            return vector.getValue(index);
        }

        @Specialization
        protected byte doI8(LLVMI8Vector vector, long index) {
            return vector.getValue(Math.toIntExact(index));
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMI1ExtractElementNode
    extends LLVMExpressionNode {
        @Specialization
        protected boolean doI1(LLVMI1Vector vector, int index) {
            return vector.getValue(index);
        }

        @Specialization
        protected boolean doI1(LLVMI1Vector vector, long index) {
            return vector.getValue(Math.toIntExact(index));
        }
    }
}

