/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vars;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.Arrays;

public abstract class LLVMReadNode
extends LLVMExpressionNode {
    protected final int slot;

    public LLVMReadNode(int slot) {
        assert (slot >= 0);
        this.slot = slot;
    }

    @Override
    public String toString() {
        return this.getShortString("slot");
    }

    public static final class LLVMDebugReadNode
    extends LLVMReadCachableNode {
        private static final IndexedSlotCache<LLVMDebugReadNode> CACHE = new IndexedSlotCache<LLVMDebugReadNode>(LLVMDebugReadNode::new);

        protected LLVMDebugReadNode(int slot) {
            super(slot);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return frame.getValue(this.slot);
        }

        public static LLVMDebugReadNode create(int slot) {
            return CACHE.get(slot);
        }
    }

    public static abstract class ForeignAttachInteropTypeNode
    extends LLVMNode {
        public abstract Object execute(Object var1, LLVMInteropType.Structured var2);

        public static ForeignAttachInteropTypeNode create() {
            return LLVMReadNodeFactory.ForeignAttachInteropTypeNodeGen.create();
        }

        @Specialization(guards={"foreigns.isForeign(object)", "!nativeTypes.hasNativeType(object)"})
        @GenerateAOT.Exclude
        protected Object doForeignNoNativeType(Object object, LLVMInteropType.Structured type, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") NativeTypeLibrary nativeTypes) {
            return LLVMTypedForeignObject.create(foreigns.asForeign(object), type);
        }

        @Fallback
        protected Object doOther(Object object, LLVMInteropType.Structured type) {
            return object;
        }
    }

    public static abstract class AttachInteropTypeNode
    extends LLVMNode {
        public abstract Object execute(Object var1, LLVMInteropType var2);

        @Specialization(guards={"type != null", "pointer.getOffset() == 0"})
        protected Object doForeign(LLVMManagedPointer pointer, LLVMInteropType.Structured type, @Cached(value="create()") ForeignAttachInteropTypeNode attach) {
            return LLVMManagedPointer.create(attach.execute(pointer.getObject(), type));
        }

        @Fallback
        protected Object doOther(Object object, LLVMInteropType type) {
            return object;
        }
    }

    public static final class LLVMObjectReadNode
    extends LLVMReadCachableNode {
        private static final IndexedSlotCache<LLVMObjectReadNode> CACHE = new IndexedSlotCache<LLVMObjectReadNode>(LLVMObjectReadNode::new);

        protected LLVMObjectReadNode(int slot) {
            super(slot);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return frame.getObject(this.slot);
        }

        public static LLVMObjectReadNode create(int slot) {
            return CACHE.get(slot);
        }
    }

    public static final class LLVM128BitFloatReadNode
    extends LLVMReadCachableNode {
        private static final IndexedSlotCache<LLVM128BitFloatReadNode> CACHE = new IndexedSlotCache<LLVM128BitFloatReadNode>(LLVM128BitFloatReadNode::new);

        protected LLVM128BitFloatReadNode(int slot) {
            super(slot);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return frame.getObject(this.slot);
        }

        public static LLVM128BitFloatReadNode create(int slot) {
            return CACHE.get(slot);
        }
    }

    public static final class LLVM80BitFloatReadNode
    extends LLVMReadCachableNode {
        private static final IndexedSlotCache<LLVM80BitFloatReadNode> CACHE = new IndexedSlotCache<LLVM80BitFloatReadNode>(LLVM80BitFloatReadNode::new);

        protected LLVM80BitFloatReadNode(int slot) {
            super(slot);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return frame.getObject(this.slot);
        }

        public static LLVM80BitFloatReadNode create(int slot) {
            return CACHE.get(slot);
        }
    }

    public static final class LLVMDoubleReadNode
    extends LLVMReadCachableNode {
        private static final IndexedSlotCache<LLVMDoubleReadNode> CACHE = new IndexedSlotCache<LLVMDoubleReadNode>(LLVMDoubleReadNode::new);

        protected LLVMDoubleReadNode(int slot) {
            super(slot);
        }

        @Override
        public double executeDouble(VirtualFrame frame) {
            return frame.getDouble(this.slot);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeDouble(frame);
        }

        public static LLVMDoubleReadNode create(int slot) {
            return CACHE.get(slot);
        }
    }

    public static final class LLVMFloatReadNode
    extends LLVMReadCachableNode {
        private static final IndexedSlotCache<LLVMFloatReadNode> CACHE = new IndexedSlotCache<LLVMFloatReadNode>(LLVMFloatReadNode::new);

        protected LLVMFloatReadNode(int slot) {
            super(slot);
        }

        @Override
        public float executeFloat(VirtualFrame frame) {
            return frame.getFloat(this.slot);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return Float.valueOf(this.executeFloat(frame));
        }

        public static LLVMFloatReadNode create(int slot) {
            return CACHE.get(slot);
        }
    }

    public static final class LLVMIReadVarBitNode
    extends LLVMReadCachableNode {
        private static final IndexedSlotCache<LLVMIReadVarBitNode> CACHE = new IndexedSlotCache<LLVMIReadVarBitNode>(LLVMIReadVarBitNode::new);

        protected LLVMIReadVarBitNode(int slot) {
            super(slot);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return frame.getObject(this.slot);
        }

        public static LLVMIReadVarBitNode create(int slot) {
            return CACHE.get(slot);
        }
    }

    public static abstract class LLVMI64ReadNode
    extends LLVMReadNode {
        protected LLVMI64ReadNode(int slot) {
            super(slot);
        }

        @Specialization(rewriteOn={FrameSlotTypeException.class})
        protected long readI64(VirtualFrame frame) throws FrameSlotTypeException {
            return frame.getLong(this.slot);
        }

        @Specialization(rewriteOn={FrameSlotTypeException.class})
        protected Object readObject(VirtualFrame frame) throws FrameSlotTypeException {
            return frame.getObject(this.slot);
        }

        @Specialization
        protected Object readGeneric(VirtualFrame frame) {
            if (frame.isLong(this.slot)) {
                return frame.getLong(this.slot);
            }
            return frame.getObject(this.slot);
        }
    }

    public static final class LLVMI32ReadNode
    extends LLVMReadCachableNode {
        private static final IndexedSlotCache<LLVMI32ReadNode> CACHE = new IndexedSlotCache<LLVMI32ReadNode>(LLVMI32ReadNode::new);

        protected LLVMI32ReadNode(int slot) {
            super(slot);
        }

        @Override
        public int executeI32(VirtualFrame frame) {
            return frame.getInt(this.slot);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeI32(frame);
        }

        public static LLVMI32ReadNode create(int slot) {
            return CACHE.get(slot);
        }
    }

    public static final class LLVMI16ReadNode
    extends LLVMReadCachableNode {
        private static final IndexedSlotCache<LLVMI16ReadNode> CACHE = new IndexedSlotCache<LLVMI16ReadNode>(LLVMI16ReadNode::new);

        protected LLVMI16ReadNode(int slot) {
            super(slot);
        }

        @Override
        public short executeI16(VirtualFrame frame) {
            return (short)frame.getInt(this.slot);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeI16(frame);
        }

        public static LLVMI16ReadNode create(int slot) {
            return CACHE.get(slot);
        }
    }

    public static final class LLVMI8ReadNode
    extends LLVMReadCachableNode {
        private static final IndexedSlotCache<LLVMI8ReadNode> CACHE = new IndexedSlotCache<LLVMI8ReadNode>(LLVMI8ReadNode::new);

        protected LLVMI8ReadNode(int slot) {
            super(slot);
        }

        @Override
        public byte executeI8(VirtualFrame frame) {
            return frame.getByte(this.slot);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeI8(frame);
        }

        public static LLVMI8ReadNode create(int slot) {
            return CACHE.get(slot);
        }
    }

    public static final class LLVMI1ReadNode
    extends LLVMReadCachableNode {
        private static final IndexedSlotCache<LLVMI1ReadNode> CACHE = new IndexedSlotCache<LLVMI1ReadNode>(LLVMI1ReadNode::new);

        protected LLVMI1ReadNode(int slot) {
            super(slot);
        }

        @Override
        public boolean executeI1(VirtualFrame frame) {
            return frame.getBoolean(this.slot);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeI1(frame);
        }

        public static LLVMI1ReadNode create(int slot) {
            return CACHE.get(slot);
        }
    }

    private static abstract class LLVMReadCachableNode
    extends LLVMReadNode {
        protected LLVMReadCachableNode(int slot) {
            super(slot);
        }

        public final boolean isAdoptable() {
            return false;
        }
    }

    public static final class IndexedSlotCache<T extends LLVMNode> {
        private static final int MIN_CACHE_SIZE = 32;
        private static final int MAX_CACHE_SIZE = 512;
        private Object[] cache = new Object[32];
        private final IndexedFunction<T> factory;

        protected IndexedSlotCache(IndexedFunction<T> factory) {
            this.factory = factory;
        }

        public T get(int slot) {
            LLVMNode result;
            Object[] c = this.cache;
            if (slot >= c.length) {
                if (slot >= 512) {
                    return (T)((Object)((LLVMNode)((Object)this.factory.get(slot))));
                }
                int newLength = Math.min(512, Math.max(slot + 1, c.length * 2));
                this.cache = c = Arrays.copyOf(c, newLength);
            }
            if ((result = (LLVMNode)((Object)c[slot])) == null) {
                result = (LLVMNode)((Object)this.factory.get(slot));
                c[slot] = result;
                assert (result != null);
            }
            return (T)((Object)result);
        }
    }

    @FunctionalInterface
    public static interface IndexedFunction<T> {
        public T get(int var1);
    }
}

