/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
public abstract class LLVMSelectNode
extends LLVMExpressionNode {

    public static abstract class LLVMGenericSelectNode
    extends LLVMSelectNode {
        @Specialization
        protected Object doOp(boolean cond, Object trueBranch, Object elseBranch, @Cached CountingConditionProfile conditionProfile) {
            return conditionProfile.profile(cond) ? trueBranch : elseBranch;
        }
    }

    public static abstract class LLVM128BitFloatSelectNode
    extends LLVMSelectNode {
        @Specialization
        protected LLVM128BitFloat doOp(boolean cond, LLVM128BitFloat trueBranch, LLVM128BitFloat elseBranch, @Cached CountingConditionProfile conditionProfile) {
            return conditionProfile.profile(cond) ? trueBranch : elseBranch;
        }
    }

    public static abstract class LLVM80BitFloatSelectNode
    extends LLVMSelectNode {
        @Specialization
        protected LLVM80BitFloat doOp(boolean cond, LLVM80BitFloat trueBranch, LLVM80BitFloat elseBranch, @Cached CountingConditionProfile conditionProfile) {
            return conditionProfile.profile(cond) ? trueBranch : elseBranch;
        }
    }

    public static abstract class LLVMDoubleSelectNode
    extends LLVMSelectNode {
        @Specialization
        protected double doOp(boolean cond, double trueBranch, double elseBranch, @Cached CountingConditionProfile conditionProfile) {
            return conditionProfile.profile(cond) ? trueBranch : elseBranch;
        }
    }

    public static abstract class LLVMFloatSelectNode
    extends LLVMSelectNode {
        @Specialization
        protected float doOp(boolean cond, float trueBranch, float elseBranch, @Cached CountingConditionProfile conditionProfile) {
            return conditionProfile.profile(cond) ? trueBranch : elseBranch;
        }
    }

    public static abstract class LLVMI64SelectNode
    extends LLVMSelectNode {
        @Specialization
        protected Object doOp(boolean cond, Object trueBranch, Object elseBranch, @Cached CountingConditionProfile conditionProfile) {
            assert (trueBranch instanceof Long || LLVMPointer.isInstance(trueBranch));
            assert (elseBranch instanceof Long || LLVMPointer.isInstance(elseBranch));
            return conditionProfile.profile(cond) ? trueBranch : elseBranch;
        }
    }

    public static abstract class LLVMI32SelectNode
    extends LLVMSelectNode {
        @Specialization
        protected int doOp(boolean cond, int trueBranch, int elseBranch, @Cached CountingConditionProfile conditionProfile) {
            return conditionProfile.profile(cond) ? trueBranch : elseBranch;
        }
    }

    public static abstract class LLVMI16SelectNode
    extends LLVMSelectNode {
        @Specialization
        protected short doOp(boolean cond, short trueBranch, short elseBranch, @Cached CountingConditionProfile conditionProfile) {
            return conditionProfile.profile(cond) ? trueBranch : elseBranch;
        }
    }

    public static abstract class LLVMI8SelectNode
    extends LLVMSelectNode {
        @Specialization
        protected byte doOp(boolean cond, byte trueBranch, byte elseBranch, @Cached CountingConditionProfile conditionProfile) {
            return conditionProfile.profile(cond) ? trueBranch : elseBranch;
        }
    }

    public static abstract class LLVMI1SelectNode
    extends LLVMSelectNode {
        @Specialization
        protected boolean doOp(boolean cond, boolean trueBranch, boolean elseBranch, @Cached CountingConditionProfile conditionProfile) {
            return conditionProfile.profile(cond) ? trueBranch : elseBranch;
        }
    }
}

