/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValueNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

public abstract class ToComparableValue
extends LLVMNode {
    public abstract long executeWithTarget(Object var1);

    @Specialization(guards={"isPointer.execute(obj)"}, rewriteOn={UnsupportedMessageException.class})
    protected long doPointer(Object obj, @Cached LLVMNativePointerSupport.IsPointerNode isPointer, @Cached LLVMNativePointerSupport.AsPointerNode asPointer) throws UnsupportedMessageException {
        return asPointer.execute(obj);
    }

    @Specialization(guards={"isPointer.execute(obj)"})
    protected long doPointerException(Object obj, @Cached LLVMNativePointerSupport.IsPointerNode isPointer, @Cached LLVMNativePointerSupport.AsPointerNode asPointer, @Cached(value="createUseOffset()") ManagedToComparableValue toComparable) {
        try {
            return asPointer.execute(obj);
        }
        catch (UnsupportedMessageException ex) {
            return this.doManaged(obj, isPointer, toComparable);
        }
    }

    @Specialization(guards={"!isPointer.execute(obj)"})
    protected long doManaged(Object obj, @Cached LLVMNativePointerSupport.IsPointerNode isPointer, @Cached(value="createUseOffset()") ManagedToComparableValue toComparable) {
        return toComparable.executeWithTarget(obj);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static long getHashCode(Object obj) {
        return (long)obj.hashCode() << 8;
    }

    @ImportStatic(value={ForeignToLLVM.ForeignToLLVMType.class})
    public static abstract class ManagedToComparableValue
    extends LLVMNode {
        private final boolean includeOffset;

        public ManagedToComparableValue(boolean includeOffset) {
            this.includeOffset = includeOffset;
        }

        abstract long executeWithTarget(Object var1);

        @Specialization
        protected long doManaged(LLVMManagedPointer address) {
            long result = ToComparableValue.getHashCode(address.getObject());
            if (this.includeOffset) {
                result += address.getOffset();
            }
            return result;
        }

        public static ManagedToComparableValue createIgnoreOffset() {
            return ToComparableValueNodeGen.ManagedToComparableValueNodeGen.create(false);
        }

        public static ManagedToComparableValue createUseOffset() {
            return ToComparableValueNodeGen.ManagedToComparableValueNodeGen.create(true);
        }

        protected ForeignToLLVM createForeignToI64() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.I64);
        }
    }
}

